<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryDestination StructType
 * @subpackage Structs
 */
class DeliveryDestination extends AbstractStructBase
{
    /**
     * The exclusions
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $exclusions;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $countryCode;
    /**
     * The weightMinKg
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $weightMinKg;
    /**
     * The weigthMaxKg
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $weigthMaxKg;
    /**
     * Constructor method for DeliveryDestination
     * @uses DeliveryDestination::setExclusions()
     * @uses DeliveryDestination::setCountryCode()
     * @uses DeliveryDestination::setWeightMinKg()
     * @uses DeliveryDestination::setWeigthMaxKg()
     * @param string $exclusions
     * @param string $countryCode
     * @param float $weightMinKg
     * @param float $weigthMaxKg
     */
    public function __construct($exclusions = null, $countryCode = null, $weightMinKg = null, $weigthMaxKg = null)
    {
        $this
            ->setExclusions($exclusions)
            ->setCountryCode($countryCode)
            ->setWeightMinKg($weightMinKg)
            ->setWeigthMaxKg($weigthMaxKg);
    }
    /**
     * Get exclusions value
     * @return string|null
     */
    public function getExclusions()
    {
        return $this->exclusions;
    }
    /**
     * Set exclusions value
     * @param string $exclusions
     * @return \StructType\DeliveryDestination
     */
    public function setExclusions($exclusions = null)
    {
        // validation for constraint: string
        if (!is_null($exclusions) && !is_string($exclusions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exclusions)), __LINE__);
        }
        $this->exclusions = $exclusions;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \StructType\DeliveryDestination
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get weightMinKg value
     * @return float|null
     */
    public function getWeightMinKg()
    {
        return $this->weightMinKg;
    }
    /**
     * Set weightMinKg value
     * @param float $weightMinKg
     * @return \StructType\DeliveryDestination
     */
    public function setWeightMinKg($weightMinKg = null)
    {
        $this->weightMinKg = $weightMinKg;
        return $this;
    }
    /**
     * Get weigthMaxKg value
     * @return float|null
     */
    public function getWeigthMaxKg()
    {
        return $this->weigthMaxKg;
    }
    /**
     * Set weigthMaxKg value
     * @param float $weigthMaxKg
     * @return \StructType\DeliveryDestination
     */
    public function setWeigthMaxKg($weigthMaxKg = null)
    {
        $this->weigthMaxKg = $weigthMaxKg;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeliveryDestination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
