<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPropsOrder ArrayType
 * @subpackage Arrays
 */
class ArrayOfPropsOrder extends AbstractStructArrayBase
{
    /**
     * The PropsOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PropsOrder[]
     */
    public $PropsOrder;
    /**
     * Constructor method for ArrayOfPropsOrder
     * @uses ArrayOfPropsOrder::setPropsOrder()
     * @param \StructType\PropsOrder[] $propsOrder
     */
    public function __construct(array $propsOrder = array())
    {
        $this
            ->setPropsOrder($propsOrder);
    }
    /**
     * Get PropsOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PropsOrder[]|null
     */
    public function getPropsOrder()
    {
        return isset($this->PropsOrder) ? $this->PropsOrder : null;
    }
    /**
     * Set PropsOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PropsOrder[] $propsOrder
     * @return \ArrayType\ArrayOfPropsOrder
     */
    public function setPropsOrder(array $propsOrder = array())
    {
        foreach ($propsOrder as $arrayOfPropsOrderPropsOrderItem) {
            // validation for constraint: itemType
            if (!$arrayOfPropsOrderPropsOrderItem instanceof \StructType\PropsOrder) {
                throw new \InvalidArgumentException(sprintf('The PropsOrder property can only contain items of \StructType\PropsOrder, "%s" given', is_object($arrayOfPropsOrderPropsOrderItem) ? get_class($arrayOfPropsOrderPropsOrderItem) : gettype($arrayOfPropsOrderPropsOrderItem)), __LINE__);
            }
        }
        if (is_null($propsOrder) || (is_array($propsOrder) && empty($propsOrder))) {
            unset($this->PropsOrder);
        } else {
            $this->PropsOrder = $propsOrder;
        }
        return $this;
    }
    /**
     * Add item to PropsOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\PropsOrder $item
     * @return \ArrayType\ArrayOfPropsOrder
     */
    public function addToPropsOrder(\StructType\PropsOrder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PropsOrder) {
            throw new \InvalidArgumentException(sprintf('The PropsOrder property can only contain items of \StructType\PropsOrder, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PropsOrder[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PropsOrder|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PropsOrder|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PropsOrder|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PropsOrder|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PropsOrder|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PropsOrder
     */
    public function getAttributeName()
    {
        return 'PropsOrder';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPropsOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
