<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingLabelPdf StructType
 * @subpackage Structs
 */
class ShippingLabelPdf extends AbstractStructBase
{
    /**
     * The pdfData
     * @var string
     */
    public $pdfData;
    /**
     * The orderNo
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $orderNo;
    /**
     * Constructor method for ShippingLabelPdf
     * @uses ShippingLabelPdf::setPdfData()
     * @uses ShippingLabelPdf::setOrderNo()
     * @param string $pdfData
     * @param string $orderNo
     */
    public function __construct($pdfData = null, $orderNo = null)
    {
        $this
            ->setPdfData($pdfData)
            ->setOrderNo($orderNo);
    }
    /**
     * Get pdfData value
     * @return string|null
     */
    public function getPdfData()
    {
        return $this->pdfData;
    }
    /**
     * Set pdfData value
     * @param string $pdfData
     * @return \StructType\ShippingLabelPdf
     */
    public function setPdfData($pdfData = null)
    {
        // validation for constraint: string
        if (!is_null($pdfData) && !is_string($pdfData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pdfData)), __LINE__);
        }
        $this->pdfData = $pdfData;
        return $this;
    }
    /**
     * Get orderNo value
     * @return string|null
     */
    public function getOrderNo()
    {
        return $this->orderNo;
    }
    /**
     * Set orderNo value
     * @param string $orderNo
     * @return \StructType\ShippingLabelPdf
     */
    public function setOrderNo($orderNo = null)
    {
        // validation for constraint: string
        if (!is_null($orderNo) && !is_string($orderNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNo)), __LINE__);
        }
        $this->orderNo = $orderNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShippingLabelPdf
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
