<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceCharge StructType
 * @subpackage Structs
 */
class ServiceCharge extends AbstractStructBase
{
    /**
     * The displayname
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $displayname;
    /**
     * The amountEurocent
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $amountEurocent;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $currency;
    /**
     * Constructor method for ServiceCharge
     * @uses ServiceCharge::setDisplayname()
     * @uses ServiceCharge::setAmountEurocent()
     * @uses ServiceCharge::setCurrency()
     * @param string $displayname
     * @param int $amountEurocent
     * @param string $currency
     */
    public function __construct($displayname = null, $amountEurocent = null, $currency = null)
    {
        $this
            ->setDisplayname($displayname)
            ->setAmountEurocent($amountEurocent)
            ->setCurrency($currency);
    }
    /**
     * Get displayname value
     * @return string|null
     */
    public function getDisplayname()
    {
        return $this->displayname;
    }
    /**
     * Set displayname value
     * @param string $displayname
     * @return \StructType\ServiceCharge
     */
    public function setDisplayname($displayname = null)
    {
        // validation for constraint: string
        if (!is_null($displayname) && !is_string($displayname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayname)), __LINE__);
        }
        $this->displayname = $displayname;
        return $this;
    }
    /**
     * Get amountEurocent value
     * @return int|null
     */
    public function getAmountEurocent()
    {
        return $this->amountEurocent;
    }
    /**
     * Set amountEurocent value
     * @param int $amountEurocent
     * @return \StructType\ServiceCharge
     */
    public function setAmountEurocent($amountEurocent = null)
    {
        // validation for constraint: int
        if (!is_null($amountEurocent) && !is_numeric($amountEurocent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($amountEurocent)), __LINE__);
        }
        $this->amountEurocent = $amountEurocent;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\ServiceCharge
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
