<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductInfo StructType
 * @subpackage Structs
 */
class ProductInfo extends AbstractStructBase
{
    /**
     * The parcelFormat
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\ParcelFormat
     */
    public $parcelFormat;
    /**
     * The deliveryDestinations
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfDeliveryDestination
     */
    public $deliveryDestinations;
    /**
     * Constructor method for ProductInfo
     * @uses ProductInfo::setParcelFormat()
     * @uses ProductInfo::setDeliveryDestinations()
     * @param \StructType\ParcelFormat $parcelFormat
     * @param \ArrayType\ArrayOfDeliveryDestination $deliveryDestinations
     */
    public function __construct(\StructType\ParcelFormat $parcelFormat = null, \ArrayType\ArrayOfDeliveryDestination $deliveryDestinations = null)
    {
        $this
            ->setParcelFormat($parcelFormat)
            ->setDeliveryDestinations($deliveryDestinations);
    }
    /**
     * Get parcelFormat value
     * @return \StructType\ParcelFormat|null
     */
    public function getParcelFormat()
    {
        return $this->parcelFormat;
    }
    /**
     * Set parcelFormat value
     * @param \StructType\ParcelFormat $parcelFormat
     * @return \StructType\ProductInfo
     */
    public function setParcelFormat(\StructType\ParcelFormat $parcelFormat = null)
    {
        $this->parcelFormat = $parcelFormat;
        return $this;
    }
    /**
     * Get deliveryDestinations value
     * @return \ArrayType\ArrayOfDeliveryDestination|null
     */
    public function getDeliveryDestinations()
    {
        return $this->deliveryDestinations;
    }
    /**
     * Set deliveryDestinations value
     * @param \ArrayType\ArrayOfDeliveryDestination $deliveryDestinations
     * @return \StructType\ProductInfo
     */
    public function setDeliveryDestinations(\ArrayType\ArrayOfDeliveryDestination $deliveryDestinations = null)
    {
        $this->deliveryDestinations = $deliveryDestinations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
