<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The addressAdd
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $addressAdd;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The houseNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $houseNumber;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $countryCode;
    /**
     * The lastname
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $lastname;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $city;
    /**
     * The district
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $district;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $postcode;
    /**
     * The street
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $street;
    /**
     * The telephoneNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $telephoneNumber;
    /**
     * The firstname
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $firstname;
    /**
     * The telephonePrefix
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $telephonePrefix;
    /**
     * Constructor method for Address
     * @uses Address::setAddressAdd()
     * @uses Address::setEmail()
     * @uses Address::setHouseNumber()
     * @uses Address::setCountryCode()
     * @uses Address::setLastname()
     * @uses Address::setCity()
     * @uses Address::setDistrict()
     * @uses Address::setPostcode()
     * @uses Address::setStreet()
     * @uses Address::setTelephoneNumber()
     * @uses Address::setFirstname()
     * @uses Address::setTelephonePrefix()
     * @param string $addressAdd
     * @param string $email
     * @param string $houseNumber
     * @param string $countryCode
     * @param string $lastname
     * @param string $city
     * @param string $district
     * @param string $postcode
     * @param string $street
     * @param string $telephoneNumber
     * @param string $firstname
     * @param string $telephonePrefix
     */
    public function __construct($addressAdd = null, $email = null, $houseNumber = null, $countryCode = null, $lastname = null, $city = null, $district = null, $postcode = null, $street = null, $telephoneNumber = null, $firstname = null, $telephonePrefix = null)
    {
        $this
            ->setAddressAdd($addressAdd)
            ->setEmail($email)
            ->setHouseNumber($houseNumber)
            ->setCountryCode($countryCode)
            ->setLastname($lastname)
            ->setCity($city)
            ->setDistrict($district)
            ->setPostcode($postcode)
            ->setStreet($street)
            ->setTelephoneNumber($telephoneNumber)
            ->setFirstname($firstname)
            ->setTelephonePrefix($telephonePrefix);
    }
    /**
     * Get addressAdd value
     * @return string|null
     */
    public function getAddressAdd()
    {
        return $this->addressAdd;
    }
    /**
     * Set addressAdd value
     * @param string $addressAdd
     * @return \StructType\Address
     */
    public function setAddressAdd($addressAdd = null)
    {
        // validation for constraint: string
        if (!is_null($addressAdd) && !is_string($addressAdd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressAdd)), __LINE__);
        }
        $this->addressAdd = $addressAdd;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Address
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \StructType\Address
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \StructType\Address
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->lastname;
    }
    /**
     * Set lastname value
     * @param string $lastname
     * @return \StructType\Address
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastname)), __LINE__);
        }
        $this->lastname = $lastname;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get district value
     * @return string|null
     */
    public function getDistrict()
    {
        return $this->district;
    }
    /**
     * Set district value
     * @param string $district
     * @return \StructType\Address
     */
    public function setDistrict($district = null)
    {
        // validation for constraint: string
        if (!is_null($district) && !is_string($district)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($district)), __LINE__);
        }
        $this->district = $district;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\Address
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\Address
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get telephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->telephoneNumber;
    }
    /**
     * Set telephoneNumber value
     * @param string $telephoneNumber
     * @return \StructType\Address
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneNumber)), __LINE__);
        }
        $this->telephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \StructType\Address
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get telephonePrefix value
     * @return string|null
     */
    public function getTelephonePrefix()
    {
        return $this->telephonePrefix;
    }
    /**
     * Set telephonePrefix value
     * @param string $telephonePrefix
     * @return \StructType\Address
     */
    public function setTelephonePrefix($telephonePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($telephonePrefix) && !is_string($telephonePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephonePrefix)), __LINE__);
        }
        $this->telephonePrefix = $telephonePrefix;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
