<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Props ServiceType
 * @subpackage Services
 */
class Props extends AbstractSoapClientBase
{
    /**
     * Sets the UserToken SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $userToken
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserToken($userToken, $nameSpace = 'http://hermes_api.service.hlg.de', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserToken', $userToken, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named propsGetPropsOrders
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserToken
     * - SOAPHeaderNamespaces: http://hermes_api.service.hlg.de
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsGetPropsOrders $parameters
     * @return \StructType\PropsGetPropsOrdersResponse|bool
     */
    public function propsGetPropsOrders(\StructType\PropsGetPropsOrders $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsGetPropsOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsProductlnformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsProductlnformation $parameters
     * @return \StructType\PropsProductlnformationResponse|bool
     */
    public function propsProductlnformation(\StructType\PropsProductlnformation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsProductlnformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsCollectionRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserToken
     * - SOAPHeaderNamespaces: http://hermes_api.service.hlg.de
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsCollectionRequest $parameters
     * @return \StructType\PropsCollectionRequestResponse|bool
     */
    public function propsCollectionRequest(\StructType\PropsCollectionRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsCollectionRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsGetPropsOrder
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserToken
     * - SOAPHeaderNamespaces: http://hermes_api.service.hlg.de
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsGetPropsOrder $parameters
     * @return \StructType\PropsGetPropsOrderResponse|bool
     */
    public function propsGetPropsOrder(\StructType\PropsGetPropsOrder $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsGetPropsOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsOrderSaveAndPrintLabelJpeg
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserToken
     * - SOAPHeaderNamespaces: http://hermes_api.service.hlg.de
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsOrderSaveAndPrintLabelJpeg $parameters
     * @return \StructType\PropsOrderSaveAndPrintLabelJpegResponse|bool
     */
    public function propsOrderSaveAndPrintLabelJpeg(\StructType\PropsOrderSaveAndPrintLabelJpeg $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsOrderSaveAndPrintLabelJpeg($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsReadShipmentStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsReadShipmentStatus $parameters
     * @return \StructType\PropsReadShipmentStatusResponse|bool
     */
    public function propsReadShipmentStatus(\StructType\PropsReadShipmentStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsReadShipmentStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsOrderPrintLabelPdf
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserToken
     * - SOAPHeaderNamespaces: http://hermes_api.service.hlg.de
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsOrderPrintLabelPdf $parameters
     * @return \StructType\PropsOrderPrintLabelPdfResponse|bool
     */
    public function propsOrderPrintLabelPdf(\StructType\PropsOrderPrintLabelPdf $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsOrderPrintLabelPdf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsCheckAvailability
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsCheckAvailability $parameters
     * @return \StructType\PropsCheckAvailabilityResponse|bool
     */
    public function propsCheckAvailability(\StructType\PropsCheckAvailability $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsCheckAvailability($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsOrderSave
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserToken
     * - SOAPHeaderNamespaces: http://hermes_api.service.hlg.de
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsOrderSave $parameters
     * @return \StructType\PropsOrderSaveResponse|bool
     */
    public function propsOrderSave(\StructType\PropsOrderSave $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsOrderSave($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsOrdersPrintLabelsPdf
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserToken
     * - SOAPHeaderNamespaces: http://hermes_api.service.hlg.de
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsOrdersPrintLabelsPdf $parameters
     * @return \StructType\PropsOrdersPrintLabelsPdfResponse|bool
     */
    public function propsOrdersPrintLabelsPdf(\StructType\PropsOrdersPrintLabelsPdf $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsOrdersPrintLabelsPdf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsCollectionCancel
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserToken
     * - SOAPHeaderNamespaces: http://hermes_api.service.hlg.de
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsCollectionCancel $parameters
     * @return \StructType\PropsCollectionCancelResponse|bool
     */
    public function propsCollectionCancel(\StructType\PropsCollectionCancel $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsCollectionCancel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsUserLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsUserLogin $parameters
     * @return \StructType\PropsUserLoginResponse|bool
     */
    public function propsUserLogin(\StructType\PropsUserLogin $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsUserLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsOrderSaveAndPrintLabelPdf
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserToken
     * - SOAPHeaderNamespaces: http://hermes_api.service.hlg.de
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsOrderSaveAndPrintLabelPdf $parameters
     * @return \StructType\PropsOrderSaveAndPrintLabelPdfResponse|bool
     */
    public function propsOrderSaveAndPrintLabelPdf(\StructType\PropsOrderSaveAndPrintLabelPdf $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsOrderSaveAndPrintLabelPdf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsListOfProductsATG
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserToken
     * - SOAPHeaderNamespaces: http://hermes_api.service.hlg.de
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsListOfProductsATG $parameters
     * @return \StructType\PropsListOfProductsATGResponse|bool
     */
    public function propsListOfProductsATG(\StructType\PropsListOfProductsATG $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsListOfProductsATG($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsOrderDelete
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserToken
     * - SOAPHeaderNamespaces: http://hermes_api.service.hlg.de
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsOrderDelete $parameters
     * @return \StructType\PropsOrderDeleteResponse|bool
     */
    public function propsOrderDelete(\StructType\PropsOrderDelete $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsOrderDelete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsOrderPrintLabelJpeg
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserToken
     * - SOAPHeaderNamespaces: http://hermes_api.service.hlg.de
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsOrderPrintLabelJpeg $parameters
     * @return \StructType\PropsOrderPrintLabelJpegResponse|bool
     */
    public function propsOrderPrintLabelJpeg(\StructType\PropsOrderPrintLabelJpeg $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsOrderPrintLabelJpeg($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsGetCollectionOrders
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserToken
     * - SOAPHeaderNamespaces: http://hermes_api.service.hlg.de
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsGetCollectionOrders $parameters
     * @return \StructType\PropsGetCollectionOrdersResponse|bool
     */
    public function propsGetCollectionOrders(\StructType\PropsGetCollectionOrders $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsGetCollectionOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named propsImportOrders
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserToken
     * - SOAPHeaderNamespaces: http://hermes_api.service.hlg.de
     * - SOAPHeaderTypes: string
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PropsImportOrders $parameters
     * @return \StructType\PropsImportOrdersResponse|bool
     */
    public function propsImportOrders(\StructType\PropsImportOrders $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->propsImportOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PropsCheckAvailabilityResponse|\StructType\PropsCollectionCancelResponse|\StructType\PropsCollectionRequestResponse|\StructType\PropsGetCollectionOrdersResponse|\StructType\PropsGetPropsOrderResponse|\StructType\PropsGetPropsOrdersResponse|\StructType\PropsImportOrdersResponse|\StructType\PropsListOfProductsATGResponse|\StructType\PropsOrderDeleteResponse|\StructType\PropsOrderPrintLabelJpegResponse|\StructType\PropsOrderPrintLabelPdfResponse|\StructType\PropsOrderSaveAndPrintLabelJpegResponse|\StructType\PropsOrderSaveAndPrintLabelPdfResponse|\StructType\PropsOrderSaveResponse|\StructType\PropsOrdersPrintLabelsPdfResponse|\StructType\PropsProductlnformationResponse|\StructType\PropsReadShipmentStatusResponse|\StructType\PropsUserLoginResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
