<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductWithPrice ArrayType
 * @subpackage Arrays
 */
class ArrayOfProductWithPrice extends AbstractStructArrayBase
{
    /**
     * The ProductWithPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductWithPrice[]
     */
    public $ProductWithPrice;
    /**
     * Constructor method for ArrayOfProductWithPrice
     * @uses ArrayOfProductWithPrice::setProductWithPrice()
     * @param \StructType\ProductWithPrice[] $productWithPrice
     */
    public function __construct(array $productWithPrice = array())
    {
        $this
            ->setProductWithPrice($productWithPrice);
    }
    /**
     * Get ProductWithPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductWithPrice[]|null
     */
    public function getProductWithPrice()
    {
        return isset($this->ProductWithPrice) ? $this->ProductWithPrice : null;
    }
    /**
     * Set ProductWithPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductWithPrice[] $productWithPrice
     * @return \ArrayType\ArrayOfProductWithPrice
     */
    public function setProductWithPrice(array $productWithPrice = array())
    {
        foreach ($productWithPrice as $arrayOfProductWithPriceProductWithPriceItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductWithPriceProductWithPriceItem instanceof \StructType\ProductWithPrice) {
                throw new \InvalidArgumentException(sprintf('The ProductWithPrice property can only contain items of \StructType\ProductWithPrice, "%s" given', is_object($arrayOfProductWithPriceProductWithPriceItem) ? get_class($arrayOfProductWithPriceProductWithPriceItem) : gettype($arrayOfProductWithPriceProductWithPriceItem)), __LINE__);
            }
        }
        if (is_null($productWithPrice) || (is_array($productWithPrice) && empty($productWithPrice))) {
            unset($this->ProductWithPrice);
        } else {
            $this->ProductWithPrice = $productWithPrice;
        }
        return $this;
    }
    /**
     * Add item to ProductWithPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductWithPrice $item
     * @return \ArrayType\ArrayOfProductWithPrice
     */
    public function addToProductWithPrice(\StructType\ProductWithPrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductWithPrice) {
            throw new \InvalidArgumentException(sprintf('The ProductWithPrice property can only contain items of \StructType\ProductWithPrice, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductWithPrice[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductWithPrice|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductWithPrice|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductWithPrice|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductWithPrice|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductWithPrice|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductWithPrice
     */
    public function getAttributeName()
    {
        return 'ProductWithPrice';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfProductWithPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
