<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderResponse extends AbstractStructArrayBase
{
    /**
     * The OrderResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderResponse[]
     */
    public $OrderResponse;
    /**
     * Constructor method for ArrayOfOrderResponse
     * @uses ArrayOfOrderResponse::setOrderResponse()
     * @param \StructType\OrderResponse[] $orderResponse
     */
    public function __construct(array $orderResponse = array())
    {
        $this
            ->setOrderResponse($orderResponse);
    }
    /**
     * Get OrderResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderResponse[]|null
     */
    public function getOrderResponse()
    {
        return isset($this->OrderResponse) ? $this->OrderResponse : null;
    }
    /**
     * Set OrderResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderResponse[] $orderResponse
     * @return \ArrayType\ArrayOfOrderResponse
     */
    public function setOrderResponse(array $orderResponse = array())
    {
        foreach ($orderResponse as $arrayOfOrderResponseOrderResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderResponseOrderResponseItem instanceof \StructType\OrderResponse) {
                throw new \InvalidArgumentException(sprintf('The OrderResponse property can only contain items of \StructType\OrderResponse, "%s" given', is_object($arrayOfOrderResponseOrderResponseItem) ? get_class($arrayOfOrderResponseOrderResponseItem) : gettype($arrayOfOrderResponseOrderResponseItem)), __LINE__);
            }
        }
        if (is_null($orderResponse) || (is_array($orderResponse) && empty($orderResponse))) {
            unset($this->OrderResponse);
        } else {
            $this->OrderResponse = $orderResponse;
        }
        return $this;
    }
    /**
     * Add item to OrderResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderResponse $item
     * @return \ArrayType\ArrayOfOrderResponse
     */
    public function addToOrderResponse(\StructType\OrderResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderResponse) {
            throw new \InvalidArgumentException(sprintf('The OrderResponse property can only contain items of \StructType\OrderResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrderResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderResponse
     */
    public function getAttributeName()
    {
        return 'OrderResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfOrderResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
