<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Place ServiceType
 */
$place = new \ServiceType\Place($options);
/**
 * Sample call for PlaceOrder operation/method
 */
if ($place->PlaceOrder(new \StructType\Order()) !== false) {
    print_r($place->getResult());
} else {
    print_r($place->getLastError());
}
/**
 * Sample call for PlaceEditedOrder operation/method
 */
if ($place->PlaceEditedOrder(new \StructType\Order()) !== false) {
    print_r($place->getResult());
} else {
    print_r($place->getLastError());
}
/**
 * Samples for Price ServiceType
 */
$price = new \ServiceType\Price($options);
/**
 * Sample call for PriceOrder operation/method
 */
if ($price->PriceOrder(new \StructType\Order()) !== false) {
    print_r($price->getResult());
} else {
    print_r($price->getLastError());
}
/**
 * Sample call for PriceEditedOrder operation/method
 */
if ($price->PriceEditedOrder(new \StructType\Order()) !== false) {
    print_r($price->getResult());
} else {
    print_r($price->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \ServiceType\Save($options);
/**
 * Sample call for SaveOrder operation/method
 */
if ($save->SaveOrder(new \StructType\Order()) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetOrderStatus operation/method
 */
if ($get->GetOrderStatus($StoreID, $StoreOrderID, $EndUserIPAddress, $PowerServerIPAddress) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrderStatuses operation/method
 */
if ($get->GetOrderStatuses($StoreID, $BusinessDate, $AsOfTime) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrderStatusViaOrderID operation/method
 */
if ($get->GetOrderStatusViaOrderID($StoreID, $OrderID, $EndUserIPAddress, $PowerServerIPAddress) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStoreInformation operation/method
 */
if ($get->GetStoreInformation($StoreID) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStoreProducts operation/method
 */
if ($get->GetStoreProducts($StoreID) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllStoreProducts operation/method
 */
if ($get->GetAllStoreProducts($StoreID) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStoreCustomers operation/method
 */
if ($get->GetStoreCustomers($StoreID) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStoreCoupons operation/method
 */
if ($get->GetStoreCoupons($StoreID) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllStoreCoupons operation/method
 */
if ($get->GetAllStoreCoupons($StoreID) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStoreStreets operation/method
 */
if ($get->GetStoreStreets($StoreID, $AllStreets) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for CancelOrder operation/method
 */
if ($cancel->CancelOrder($StoreID, $StoreOrderID, $Reason, $EndUserIPAddress, $PowerServerIPAddress) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for CancelOrderViaOrderID operation/method
 */
if ($cancel->CancelOrderViaOrderID($StoreID, $OrderID, $Reason, $EndUserIPAddress, $PowerServerIPAddress) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Test ServiceType
 */
$test = new \ServiceType\Test($options);
/**
 * Sample call for TestConnection operation/method
 */
if ($test->TestConnection($Value) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Samples for Popup ServiceType
 */
$popup = new \ServiceType\Popup($options);
/**
 * Sample call for PopupMessage operation/method
 */
if ($popup->PopupMessage($StoreID, $Message) !== false) {
    print_r($popup->getResult());
} else {
    print_r($popup->getLastError());
}
