<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WalletInformation StructType
 * @subpackage Structs
 */
class WalletInformation extends AbstractStructBase
{
    /**
     * The WalletType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WalletType;
    /**
     * The WalletInfo1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WalletInfo1;
    /**
     * The WalletInfo2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WalletInfo2;
    /**
     * Constructor method for WalletInformation
     * @uses WalletInformation::setWalletType()
     * @uses WalletInformation::setWalletInfo1()
     * @uses WalletInformation::setWalletInfo2()
     * @param string $walletType
     * @param string $walletInfo1
     * @param string $walletInfo2
     */
    public function __construct($walletType = null, $walletInfo1 = null, $walletInfo2 = null)
    {
        $this
            ->setWalletType($walletType)
            ->setWalletInfo1($walletInfo1)
            ->setWalletInfo2($walletInfo2);
    }
    /**
     * Get WalletType value
     * @return string|null
     */
    public function getWalletType()
    {
        return $this->WalletType;
    }
    /**
     * Set WalletType value
     * @param string $walletType
     * @return \StructType\WalletInformation
     */
    public function setWalletType($walletType = null)
    {
        // validation for constraint: string
        if (!is_null($walletType) && !is_string($walletType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($walletType)), __LINE__);
        }
        $this->WalletType = $walletType;
        return $this;
    }
    /**
     * Get WalletInfo1 value
     * @return string|null
     */
    public function getWalletInfo1()
    {
        return $this->WalletInfo1;
    }
    /**
     * Set WalletInfo1 value
     * @param string $walletInfo1
     * @return \StructType\WalletInformation
     */
    public function setWalletInfo1($walletInfo1 = null)
    {
        // validation for constraint: string
        if (!is_null($walletInfo1) && !is_string($walletInfo1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($walletInfo1)), __LINE__);
        }
        $this->WalletInfo1 = $walletInfo1;
        return $this;
    }
    /**
     * Get WalletInfo2 value
     * @return string|null
     */
    public function getWalletInfo2()
    {
        return $this->WalletInfo2;
    }
    /**
     * Set WalletInfo2 value
     * @param string $walletInfo2
     * @return \StructType\WalletInformation
     */
    public function setWalletInfo2($walletInfo2 = null)
    {
        // validation for constraint: string
        if (!is_null($walletInfo2) && !is_string($walletInfo2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($walletInfo2)), __LINE__);
        }
        $this->WalletInfo2 = $walletInfo2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WalletInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
