<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoreCustomers StructType
 * @subpackage Structs
 */
class StoreCustomers extends AbstractStructBase
{
    /**
     * The StoreID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StoreID;
    /**
     * The Customers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Customers;
    /**
     * Constructor method for StoreCustomers
     * @uses StoreCustomers::setStoreID()
     * @uses StoreCustomers::setCustomers()
     * @param string $storeID
     * @param string $customers
     */
    public function __construct($storeID = null, $customers = null)
    {
        $this
            ->setStoreID($storeID)
            ->setCustomers($customers);
    }
    /**
     * Get StoreID value
     * @return string
     */
    public function getStoreID()
    {
        return $this->StoreID;
    }
    /**
     * Set StoreID value
     * @param string $storeID
     * @return \StructType\StoreCustomers
     */
    public function setStoreID($storeID = null)
    {
        // validation for constraint: string
        if (!is_null($storeID) && !is_string($storeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($storeID)), __LINE__);
        }
        $this->StoreID = $storeID;
        return $this;
    }
    /**
     * Get Customers value
     * @return string
     */
    public function getCustomers()
    {
        return $this->Customers;
    }
    /**
     * Set Customers value
     * @param string $customers
     * @return \StructType\StoreCustomers
     */
    public function setCustomers($customers = null)
    {
        // validation for constraint: string
        if (!is_null($customers) && !is_string($customers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customers)), __LINE__);
        }
        $this->Customers = $customers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoreCustomers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
