<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoreCoupons StructType
 * @subpackage Structs
 */
class StoreCoupons extends AbstractStructBase
{
    /**
     * The StoreID
     * @var string
     */
    public $StoreID;
    /**
     * The CouponGroups
     * @var \StructType\CouponGroups
     */
    public $CouponGroups;
    /**
     * The Coupons
     * @var \StructType\Coupons
     */
    public $Coupons;
    /**
     * Constructor method for StoreCoupons
     * @uses StoreCoupons::setStoreID()
     * @uses StoreCoupons::setCouponGroups()
     * @uses StoreCoupons::setCoupons()
     * @param string $storeID
     * @param \StructType\CouponGroups $couponGroups
     * @param \StructType\Coupons $coupons
     */
    public function __construct($storeID = null, \StructType\CouponGroups $couponGroups = null, \StructType\Coupons $coupons = null)
    {
        $this
            ->setStoreID($storeID)
            ->setCouponGroups($couponGroups)
            ->setCoupons($coupons);
    }
    /**
     * Get StoreID value
     * @return string|null
     */
    public function getStoreID()
    {
        return $this->StoreID;
    }
    /**
     * Set StoreID value
     * @param string $storeID
     * @return \StructType\StoreCoupons
     */
    public function setStoreID($storeID = null)
    {
        // validation for constraint: string
        if (!is_null($storeID) && !is_string($storeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($storeID)), __LINE__);
        }
        $this->StoreID = $storeID;
        return $this;
    }
    /**
     * Get CouponGroups value
     * @return \StructType\CouponGroups|null
     */
    public function getCouponGroups()
    {
        return $this->CouponGroups;
    }
    /**
     * Set CouponGroups value
     * @param \StructType\CouponGroups $couponGroups
     * @return \StructType\StoreCoupons
     */
    public function setCouponGroups(\StructType\CouponGroups $couponGroups = null)
    {
        $this->CouponGroups = $couponGroups;
        return $this;
    }
    /**
     * Get Coupons value
     * @return \StructType\Coupons|null
     */
    public function getCoupons()
    {
        return $this->Coupons;
    }
    /**
     * Set Coupons value
     * @param \StructType\Coupons $coupons
     * @return \StructType\StoreCoupons
     */
    public function setCoupons(\StructType\Coupons $coupons = null)
    {
        $this->Coupons = $coupons;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoreCoupons
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
