<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceMethods StructType
 * @subpackage Structs
 */
class ServiceMethods extends AbstractStructBase
{
    /**
     * The ServiceMethod
     * @var string
     */
    public $ServiceMethod;
    /**
     * Constructor method for ServiceMethods
     * @uses ServiceMethods::setServiceMethod()
     * @param string $serviceMethod
     */
    public function __construct($serviceMethod = null)
    {
        $this
            ->setServiceMethod($serviceMethod);
    }
    /**
     * Get ServiceMethod value
     * @return string|null
     */
    public function getServiceMethod()
    {
        return $this->ServiceMethod;
    }
    /**
     * Set ServiceMethod value
     * @param string $serviceMethod
     * @return \StructType\ServiceMethods
     */
    public function setServiceMethod($serviceMethod = null)
    {
        // validation for constraint: string
        if (!is_null($serviceMethod) && !is_string($serviceMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceMethod)), __LINE__);
        }
        $this->ServiceMethod = $serviceMethod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceMethods
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
