<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductCode StructType
 * @subpackage Structs
 */
class ProductCode extends AbstractStructBase
{
    /**
     * The ProductCodeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductCodeName;
    /**
     * The ProductCodePart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductCodePart;
    /**
     * Constructor method for ProductCode
     * @uses ProductCode::setProductCodeName()
     * @uses ProductCode::setProductCodePart()
     * @param string $productCodeName
     * @param string $productCodePart
     */
    public function __construct($productCodeName = null, $productCodePart = null)
    {
        $this
            ->setProductCodeName($productCodeName)
            ->setProductCodePart($productCodePart);
    }
    /**
     * Get ProductCodeName value
     * @return string|null
     */
    public function getProductCodeName()
    {
        return $this->ProductCodeName;
    }
    /**
     * Set ProductCodeName value
     * @param string $productCodeName
     * @return \StructType\ProductCode
     */
    public function setProductCodeName($productCodeName = null)
    {
        // validation for constraint: string
        if (!is_null($productCodeName) && !is_string($productCodeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productCodeName)), __LINE__);
        }
        $this->ProductCodeName = $productCodeName;
        return $this;
    }
    /**
     * Get ProductCodePart value
     * @return string|null
     */
    public function getProductCodePart()
    {
        return $this->ProductCodePart;
    }
    /**
     * Set ProductCodePart value
     * @param string $productCodePart
     * @return \StructType\ProductCode
     */
    public function setProductCodePart($productCodePart = null)
    {
        // validation for constraint: string
        if (!is_null($productCodePart) && !is_string($productCodePart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productCodePart)), __LINE__);
        }
        $this->ProductCodePart = $productCodePart;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
