<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment StructType
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The CashPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CashPayment[]
     */
    public $CashPayment;
    /**
     * The CheckPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CheckPayment[]
     */
    public $CheckPayment;
    /**
     * The GiftCardPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GiftCardPayment[]
     */
    public $GiftCardPayment;
    /**
     * The CreditCardPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CreditCardPayment[]
     */
    public $CreditCardPayment;
    /**
     * The PointsPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PointsPayment[]
     */
    public $PointsPayment;
    /**
     * Constructor method for Payment
     * @uses Payment::setCashPayment()
     * @uses Payment::setCheckPayment()
     * @uses Payment::setGiftCardPayment()
     * @uses Payment::setCreditCardPayment()
     * @uses Payment::setPointsPayment()
     * @param \StructType\CashPayment[] $cashPayment
     * @param \StructType\CheckPayment[] $checkPayment
     * @param \StructType\GiftCardPayment[] $giftCardPayment
     * @param \StructType\CreditCardPayment[] $creditCardPayment
     * @param \StructType\PointsPayment[] $pointsPayment
     */
    public function __construct(array $cashPayment = array(), array $checkPayment = array(), array $giftCardPayment = array(), array $creditCardPayment = array(), array $pointsPayment = array())
    {
        $this
            ->setCashPayment($cashPayment)
            ->setCheckPayment($checkPayment)
            ->setGiftCardPayment($giftCardPayment)
            ->setCreditCardPayment($creditCardPayment)
            ->setPointsPayment($pointsPayment);
    }
    /**
     * Get CashPayment value
     * @return \StructType\CashPayment[]|null
     */
    public function getCashPayment()
    {
        return $this->CashPayment;
    }
    /**
     * Set CashPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\CashPayment[] $cashPayment
     * @return \StructType\Payment
     */
    public function setCashPayment(array $cashPayment = array())
    {
        foreach ($cashPayment as $paymentCashPaymentItem) {
            // validation for constraint: itemType
            if (!$paymentCashPaymentItem instanceof \StructType\CashPayment) {
                throw new \InvalidArgumentException(sprintf('The CashPayment property can only contain items of \StructType\CashPayment, "%s" given', is_object($paymentCashPaymentItem) ? get_class($paymentCashPaymentItem) : gettype($paymentCashPaymentItem)), __LINE__);
            }
        }
        $this->CashPayment = $cashPayment;
        return $this;
    }
    /**
     * Add item to CashPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\CashPayment $item
     * @return \StructType\Payment
     */
    public function addToCashPayment(\StructType\CashPayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CashPayment) {
            throw new \InvalidArgumentException(sprintf('The CashPayment property can only contain items of \StructType\CashPayment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CashPayment[] = $item;
        return $this;
    }
    /**
     * Get CheckPayment value
     * @return \StructType\CheckPayment[]|null
     */
    public function getCheckPayment()
    {
        return $this->CheckPayment;
    }
    /**
     * Set CheckPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\CheckPayment[] $checkPayment
     * @return \StructType\Payment
     */
    public function setCheckPayment(array $checkPayment = array())
    {
        foreach ($checkPayment as $paymentCheckPaymentItem) {
            // validation for constraint: itemType
            if (!$paymentCheckPaymentItem instanceof \StructType\CheckPayment) {
                throw new \InvalidArgumentException(sprintf('The CheckPayment property can only contain items of \StructType\CheckPayment, "%s" given', is_object($paymentCheckPaymentItem) ? get_class($paymentCheckPaymentItem) : gettype($paymentCheckPaymentItem)), __LINE__);
            }
        }
        $this->CheckPayment = $checkPayment;
        return $this;
    }
    /**
     * Add item to CheckPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\CheckPayment $item
     * @return \StructType\Payment
     */
    public function addToCheckPayment(\StructType\CheckPayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CheckPayment) {
            throw new \InvalidArgumentException(sprintf('The CheckPayment property can only contain items of \StructType\CheckPayment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CheckPayment[] = $item;
        return $this;
    }
    /**
     * Get GiftCardPayment value
     * @return \StructType\GiftCardPayment[]|null
     */
    public function getGiftCardPayment()
    {
        return $this->GiftCardPayment;
    }
    /**
     * Set GiftCardPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\GiftCardPayment[] $giftCardPayment
     * @return \StructType\Payment
     */
    public function setGiftCardPayment(array $giftCardPayment = array())
    {
        foreach ($giftCardPayment as $paymentGiftCardPaymentItem) {
            // validation for constraint: itemType
            if (!$paymentGiftCardPaymentItem instanceof \StructType\GiftCardPayment) {
                throw new \InvalidArgumentException(sprintf('The GiftCardPayment property can only contain items of \StructType\GiftCardPayment, "%s" given', is_object($paymentGiftCardPaymentItem) ? get_class($paymentGiftCardPaymentItem) : gettype($paymentGiftCardPaymentItem)), __LINE__);
            }
        }
        $this->GiftCardPayment = $giftCardPayment;
        return $this;
    }
    /**
     * Add item to GiftCardPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\GiftCardPayment $item
     * @return \StructType\Payment
     */
    public function addToGiftCardPayment(\StructType\GiftCardPayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GiftCardPayment) {
            throw new \InvalidArgumentException(sprintf('The GiftCardPayment property can only contain items of \StructType\GiftCardPayment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GiftCardPayment[] = $item;
        return $this;
    }
    /**
     * Get CreditCardPayment value
     * @return \StructType\CreditCardPayment[]|null
     */
    public function getCreditCardPayment()
    {
        return $this->CreditCardPayment;
    }
    /**
     * Set CreditCardPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\CreditCardPayment[] $creditCardPayment
     * @return \StructType\Payment
     */
    public function setCreditCardPayment(array $creditCardPayment = array())
    {
        foreach ($creditCardPayment as $paymentCreditCardPaymentItem) {
            // validation for constraint: itemType
            if (!$paymentCreditCardPaymentItem instanceof \StructType\CreditCardPayment) {
                throw new \InvalidArgumentException(sprintf('The CreditCardPayment property can only contain items of \StructType\CreditCardPayment, "%s" given', is_object($paymentCreditCardPaymentItem) ? get_class($paymentCreditCardPaymentItem) : gettype($paymentCreditCardPaymentItem)), __LINE__);
            }
        }
        $this->CreditCardPayment = $creditCardPayment;
        return $this;
    }
    /**
     * Add item to CreditCardPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\CreditCardPayment $item
     * @return \StructType\Payment
     */
    public function addToCreditCardPayment(\StructType\CreditCardPayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CreditCardPayment) {
            throw new \InvalidArgumentException(sprintf('The CreditCardPayment property can only contain items of \StructType\CreditCardPayment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CreditCardPayment[] = $item;
        return $this;
    }
    /**
     * Get PointsPayment value
     * @return \StructType\PointsPayment[]|null
     */
    public function getPointsPayment()
    {
        return $this->PointsPayment;
    }
    /**
     * Set PointsPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\PointsPayment[] $pointsPayment
     * @return \StructType\Payment
     */
    public function setPointsPayment(array $pointsPayment = array())
    {
        foreach ($pointsPayment as $paymentPointsPaymentItem) {
            // validation for constraint: itemType
            if (!$paymentPointsPaymentItem instanceof \StructType\PointsPayment) {
                throw new \InvalidArgumentException(sprintf('The PointsPayment property can only contain items of \StructType\PointsPayment, "%s" given', is_object($paymentPointsPaymentItem) ? get_class($paymentPointsPaymentItem) : gettype($paymentPointsPaymentItem)), __LINE__);
            }
        }
        $this->PointsPayment = $pointsPayment;
        return $this;
    }
    /**
     * Add item to PointsPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\PointsPayment $item
     * @return \StructType\Payment
     */
    public function addToPointsPayment(\StructType\PointsPayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PointsPayment) {
            throw new \InvalidArgumentException(sprintf('The PointsPayment property can only contain items of \StructType\PointsPayment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PointsPayment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Payment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
