<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderInfoCollection StructType
 * @subpackage Structs
 */
class OrderInfoCollection extends AbstractStructBase
{
    /**
     * The OrderInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\OrderInfo[]
     */
    public $OrderInfo;
    /**
     * Constructor method for OrderInfoCollection
     * @uses OrderInfoCollection::setOrderInfo()
     * @param \StructType\OrderInfo[] $orderInfo
     */
    public function __construct(array $orderInfo = array())
    {
        $this
            ->setOrderInfo($orderInfo);
    }
    /**
     * Get OrderInfo value
     * @return \StructType\OrderInfo[]|null
     */
    public function getOrderInfo()
    {
        return $this->OrderInfo;
    }
    /**
     * Set OrderInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderInfo[] $orderInfo
     * @return \StructType\OrderInfoCollection
     */
    public function setOrderInfo(array $orderInfo = array())
    {
        foreach ($orderInfo as $orderInfoCollectionOrderInfoItem) {
            // validation for constraint: itemType
            if (!$orderInfoCollectionOrderInfoItem instanceof \StructType\OrderInfo) {
                throw new \InvalidArgumentException(sprintf('The OrderInfo property can only contain items of \StructType\OrderInfo, "%s" given', is_object($orderInfoCollectionOrderInfoItem) ? get_class($orderInfoCollectionOrderInfoItem) : gettype($orderInfoCollectionOrderInfoItem)), __LINE__);
            }
        }
        $this->OrderInfo = $orderInfo;
        return $this;
    }
    /**
     * Add item to OrderInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderInfo $item
     * @return \StructType\OrderInfoCollection
     */
    public function addToOrderInfo(\StructType\OrderInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderInfo) {
            throw new \InvalidArgumentException(sprintf('The OrderInfo property can only contain items of \StructType\OrderInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrderInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderInfoCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
