<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Order StructType
 * @subpackage Structs
 */
class Order extends AbstractStructBase
{
    /**
     * The StoreID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StoreID;
    /**
     * The ServiceMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceMethod;
    /**
     * The OrderSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderSource
     */
    public $OrderSource;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Customer
     */
    public $Customer;
    /**
     * The OrderTakeSeconds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderTakeSeconds;
    /**
     * The AdvanceOrderTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdvanceOrderTime;
    /**
     * The AdvanceOrderTimeLocal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdvanceOrderTimeLocal;
    /**
     * The TestOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TestOrder;
    /**
     * The TestDelayMS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TestDelayMS;
    /**
     * The DeliveryInstructions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryInstructions;
    /**
     * The Coupons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Coupons
     */
    public $Coupons;
    /**
     * The OrderItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderItems
     */
    public $OrderItems;
    /**
     * The AddedOrderItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderItems
     */
    public $AddedOrderItems;
    /**
     * The DeletedOrderItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderItems
     */
    public $DeletedOrderItems;
    /**
     * The Payment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Payment
     */
    public $Payment;
    /**
     * The OrderOverrideAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderOverrideAmount;
    /**
     * The OrderOverrideType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderOverrideType;
    /**
     * The OrderOverrideCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderOverrideCode;
    /**
     * The OrderOverrideDescriptiveText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderOverrideDescriptiveText;
    /**
     * The StoreOrderIDForEdit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StoreOrderIDForEdit;
    /**
     * The OrderInfoCollection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderInfoCollection
     */
    public $OrderInfoCollection;
    /**
     * The IsExpedited
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsExpedited;
    /**
     * The PendingOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $PendingOrder;
    /**
     * The LoyaltyNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoyaltyNumber;
    /**
     * The FundRaising
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FundRaising;
    /**
     * The OneTimeCustomerComment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OneTimeCustomerComment;
    /**
     * The orderid
     * @var string
     */
    public $orderid;
    /**
     * The language
     * @var string
     */
    public $language;
    /**
     * The currency
     * @var string
     */
    public $currency;
    /**
     * Constructor method for Order
     * @uses Order::setStoreID()
     * @uses Order::setServiceMethod()
     * @uses Order::setOrderSource()
     * @uses Order::setCustomer()
     * @uses Order::setOrderTakeSeconds()
     * @uses Order::setAdvanceOrderTime()
     * @uses Order::setAdvanceOrderTimeLocal()
     * @uses Order::setTestOrder()
     * @uses Order::setTestDelayMS()
     * @uses Order::setDeliveryInstructions()
     * @uses Order::setCoupons()
     * @uses Order::setOrderItems()
     * @uses Order::setAddedOrderItems()
     * @uses Order::setDeletedOrderItems()
     * @uses Order::setPayment()
     * @uses Order::setOrderOverrideAmount()
     * @uses Order::setOrderOverrideType()
     * @uses Order::setOrderOverrideCode()
     * @uses Order::setOrderOverrideDescriptiveText()
     * @uses Order::setStoreOrderIDForEdit()
     * @uses Order::setOrderInfoCollection()
     * @uses Order::setIsExpedited()
     * @uses Order::setPendingOrder()
     * @uses Order::setLoyaltyNumber()
     * @uses Order::setFundRaising()
     * @uses Order::setOneTimeCustomerComment()
     * @uses Order::setOrderid()
     * @uses Order::setLanguage()
     * @uses Order::setCurrency()
     * @param string $storeID
     * @param string $serviceMethod
     * @param \StructType\OrderSource $orderSource
     * @param \StructType\Customer $customer
     * @param string $orderTakeSeconds
     * @param string $advanceOrderTime
     * @param string $advanceOrderTimeLocal
     * @param string $testOrder
     * @param string $testDelayMS
     * @param string $deliveryInstructions
     * @param \StructType\Coupons $coupons
     * @param \StructType\OrderItems $orderItems
     * @param \StructType\OrderItems $addedOrderItems
     * @param \StructType\OrderItems $deletedOrderItems
     * @param \StructType\Payment $payment
     * @param string $orderOverrideAmount
     * @param string $orderOverrideType
     * @param string $orderOverrideCode
     * @param string $orderOverrideDescriptiveText
     * @param string $storeOrderIDForEdit
     * @param \StructType\OrderInfoCollection $orderInfoCollection
     * @param bool $isExpedited
     * @param bool $pendingOrder
     * @param string $loyaltyNumber
     * @param string $fundRaising
     * @param string $oneTimeCustomerComment
     * @param string $orderid
     * @param string $language
     * @param string $currency
     */
    public function __construct($storeID = null, $serviceMethod = null, \StructType\OrderSource $orderSource = null, \StructType\Customer $customer = null, $orderTakeSeconds = null, $advanceOrderTime = null, $advanceOrderTimeLocal = null, $testOrder = null, $testDelayMS = null, $deliveryInstructions = null, \StructType\Coupons $coupons = null, \StructType\OrderItems $orderItems = null, \StructType\OrderItems $addedOrderItems = null, \StructType\OrderItems $deletedOrderItems = null, \StructType\Payment $payment = null, $orderOverrideAmount = null, $orderOverrideType = null, $orderOverrideCode = null, $orderOverrideDescriptiveText = null, $storeOrderIDForEdit = null, \StructType\OrderInfoCollection $orderInfoCollection = null, $isExpedited = null, $pendingOrder = null, $loyaltyNumber = null, $fundRaising = null, $oneTimeCustomerComment = null, $orderid = null, $language = null, $currency = null)
    {
        $this
            ->setStoreID($storeID)
            ->setServiceMethod($serviceMethod)
            ->setOrderSource($orderSource)
            ->setCustomer($customer)
            ->setOrderTakeSeconds($orderTakeSeconds)
            ->setAdvanceOrderTime($advanceOrderTime)
            ->setAdvanceOrderTimeLocal($advanceOrderTimeLocal)
            ->setTestOrder($testOrder)
            ->setTestDelayMS($testDelayMS)
            ->setDeliveryInstructions($deliveryInstructions)
            ->setCoupons($coupons)
            ->setOrderItems($orderItems)
            ->setAddedOrderItems($addedOrderItems)
            ->setDeletedOrderItems($deletedOrderItems)
            ->setPayment($payment)
            ->setOrderOverrideAmount($orderOverrideAmount)
            ->setOrderOverrideType($orderOverrideType)
            ->setOrderOverrideCode($orderOverrideCode)
            ->setOrderOverrideDescriptiveText($orderOverrideDescriptiveText)
            ->setStoreOrderIDForEdit($storeOrderIDForEdit)
            ->setOrderInfoCollection($orderInfoCollection)
            ->setIsExpedited($isExpedited)
            ->setPendingOrder($pendingOrder)
            ->setLoyaltyNumber($loyaltyNumber)
            ->setFundRaising($fundRaising)
            ->setOneTimeCustomerComment($oneTimeCustomerComment)
            ->setOrderid($orderid)
            ->setLanguage($language)
            ->setCurrency($currency);
    }
    /**
     * Get StoreID value
     * @return string
     */
    public function getStoreID()
    {
        return $this->StoreID;
    }
    /**
     * Set StoreID value
     * @param string $storeID
     * @return \StructType\Order
     */
    public function setStoreID($storeID = null)
    {
        // validation for constraint: string
        if (!is_null($storeID) && !is_string($storeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($storeID)), __LINE__);
        }
        $this->StoreID = $storeID;
        return $this;
    }
    /**
     * Get ServiceMethod value
     * @return string
     */
    public function getServiceMethod()
    {
        return $this->ServiceMethod;
    }
    /**
     * Set ServiceMethod value
     * @param string $serviceMethod
     * @return \StructType\Order
     */
    public function setServiceMethod($serviceMethod = null)
    {
        // validation for constraint: string
        if (!is_null($serviceMethod) && !is_string($serviceMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceMethod)), __LINE__);
        }
        $this->ServiceMethod = $serviceMethod;
        return $this;
    }
    /**
     * Get OrderSource value
     * @return \StructType\OrderSource
     */
    public function getOrderSource()
    {
        return $this->OrderSource;
    }
    /**
     * Set OrderSource value
     * @param \StructType\OrderSource $orderSource
     * @return \StructType\Order
     */
    public function setOrderSource(\StructType\OrderSource $orderSource = null)
    {
        $this->OrderSource = $orderSource;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\Customer
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\Customer $customer
     * @return \StructType\Order
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get OrderTakeSeconds value
     * @return string|null
     */
    public function getOrderTakeSeconds()
    {
        return $this->OrderTakeSeconds;
    }
    /**
     * Set OrderTakeSeconds value
     * @param string $orderTakeSeconds
     * @return \StructType\Order
     */
    public function setOrderTakeSeconds($orderTakeSeconds = null)
    {
        // validation for constraint: string
        if (!is_null($orderTakeSeconds) && !is_string($orderTakeSeconds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderTakeSeconds)), __LINE__);
        }
        $this->OrderTakeSeconds = $orderTakeSeconds;
        return $this;
    }
    /**
     * Get AdvanceOrderTime value
     * @return string|null
     */
    public function getAdvanceOrderTime()
    {
        return $this->AdvanceOrderTime;
    }
    /**
     * Set AdvanceOrderTime value
     * @param string $advanceOrderTime
     * @return \StructType\Order
     */
    public function setAdvanceOrderTime($advanceOrderTime = null)
    {
        // validation for constraint: string
        if (!is_null($advanceOrderTime) && !is_string($advanceOrderTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($advanceOrderTime)), __LINE__);
        }
        $this->AdvanceOrderTime = $advanceOrderTime;
        return $this;
    }
    /**
     * Get AdvanceOrderTimeLocal value
     * @return string|null
     */
    public function getAdvanceOrderTimeLocal()
    {
        return $this->AdvanceOrderTimeLocal;
    }
    /**
     * Set AdvanceOrderTimeLocal value
     * @param string $advanceOrderTimeLocal
     * @return \StructType\Order
     */
    public function setAdvanceOrderTimeLocal($advanceOrderTimeLocal = null)
    {
        // validation for constraint: string
        if (!is_null($advanceOrderTimeLocal) && !is_string($advanceOrderTimeLocal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($advanceOrderTimeLocal)), __LINE__);
        }
        $this->AdvanceOrderTimeLocal = $advanceOrderTimeLocal;
        return $this;
    }
    /**
     * Get TestOrder value
     * @return string|null
     */
    public function getTestOrder()
    {
        return $this->TestOrder;
    }
    /**
     * Set TestOrder value
     * @param string $testOrder
     * @return \StructType\Order
     */
    public function setTestOrder($testOrder = null)
    {
        // validation for constraint: string
        if (!is_null($testOrder) && !is_string($testOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($testOrder)), __LINE__);
        }
        $this->TestOrder = $testOrder;
        return $this;
    }
    /**
     * Get TestDelayMS value
     * @return string|null
     */
    public function getTestDelayMS()
    {
        return $this->TestDelayMS;
    }
    /**
     * Set TestDelayMS value
     * @param string $testDelayMS
     * @return \StructType\Order
     */
    public function setTestDelayMS($testDelayMS = null)
    {
        // validation for constraint: string
        if (!is_null($testDelayMS) && !is_string($testDelayMS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($testDelayMS)), __LINE__);
        }
        $this->TestDelayMS = $testDelayMS;
        return $this;
    }
    /**
     * Get DeliveryInstructions value
     * @return string|null
     */
    public function getDeliveryInstructions()
    {
        return $this->DeliveryInstructions;
    }
    /**
     * Set DeliveryInstructions value
     * @param string $deliveryInstructions
     * @return \StructType\Order
     */
    public function setDeliveryInstructions($deliveryInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryInstructions) && !is_string($deliveryInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryInstructions)), __LINE__);
        }
        $this->DeliveryInstructions = $deliveryInstructions;
        return $this;
    }
    /**
     * Get Coupons value
     * @return \StructType\Coupons|null
     */
    public function getCoupons()
    {
        return $this->Coupons;
    }
    /**
     * Set Coupons value
     * @param \StructType\Coupons $coupons
     * @return \StructType\Order
     */
    public function setCoupons(\StructType\Coupons $coupons = null)
    {
        $this->Coupons = $coupons;
        return $this;
    }
    /**
     * Get OrderItems value
     * @return \StructType\OrderItems|null
     */
    public function getOrderItems()
    {
        return $this->OrderItems;
    }
    /**
     * Set OrderItems value
     * @param \StructType\OrderItems $orderItems
     * @return \StructType\Order
     */
    public function setOrderItems(\StructType\OrderItems $orderItems = null)
    {
        $this->OrderItems = $orderItems;
        return $this;
    }
    /**
     * Get AddedOrderItems value
     * @return \StructType\OrderItems|null
     */
    public function getAddedOrderItems()
    {
        return $this->AddedOrderItems;
    }
    /**
     * Set AddedOrderItems value
     * @param \StructType\OrderItems $addedOrderItems
     * @return \StructType\Order
     */
    public function setAddedOrderItems(\StructType\OrderItems $addedOrderItems = null)
    {
        $this->AddedOrderItems = $addedOrderItems;
        return $this;
    }
    /**
     * Get DeletedOrderItems value
     * @return \StructType\OrderItems|null
     */
    public function getDeletedOrderItems()
    {
        return $this->DeletedOrderItems;
    }
    /**
     * Set DeletedOrderItems value
     * @param \StructType\OrderItems $deletedOrderItems
     * @return \StructType\Order
     */
    public function setDeletedOrderItems(\StructType\OrderItems $deletedOrderItems = null)
    {
        $this->DeletedOrderItems = $deletedOrderItems;
        return $this;
    }
    /**
     * Get Payment value
     * @return \StructType\Payment|null
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param \StructType\Payment $payment
     * @return \StructType\Order
     */
    public function setPayment(\StructType\Payment $payment = null)
    {
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Get OrderOverrideAmount value
     * @return string|null
     */
    public function getOrderOverrideAmount()
    {
        return $this->OrderOverrideAmount;
    }
    /**
     * Set OrderOverrideAmount value
     * @param string $orderOverrideAmount
     * @return \StructType\Order
     */
    public function setOrderOverrideAmount($orderOverrideAmount = null)
    {
        // validation for constraint: string
        if (!is_null($orderOverrideAmount) && !is_string($orderOverrideAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderOverrideAmount)), __LINE__);
        }
        $this->OrderOverrideAmount = $orderOverrideAmount;
        return $this;
    }
    /**
     * Get OrderOverrideType value
     * @return string|null
     */
    public function getOrderOverrideType()
    {
        return $this->OrderOverrideType;
    }
    /**
     * Set OrderOverrideType value
     * @param string $orderOverrideType
     * @return \StructType\Order
     */
    public function setOrderOverrideType($orderOverrideType = null)
    {
        // validation for constraint: string
        if (!is_null($orderOverrideType) && !is_string($orderOverrideType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderOverrideType)), __LINE__);
        }
        $this->OrderOverrideType = $orderOverrideType;
        return $this;
    }
    /**
     * Get OrderOverrideCode value
     * @return string|null
     */
    public function getOrderOverrideCode()
    {
        return $this->OrderOverrideCode;
    }
    /**
     * Set OrderOverrideCode value
     * @param string $orderOverrideCode
     * @return \StructType\Order
     */
    public function setOrderOverrideCode($orderOverrideCode = null)
    {
        // validation for constraint: string
        if (!is_null($orderOverrideCode) && !is_string($orderOverrideCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderOverrideCode)), __LINE__);
        }
        $this->OrderOverrideCode = $orderOverrideCode;
        return $this;
    }
    /**
     * Get OrderOverrideDescriptiveText value
     * @return string|null
     */
    public function getOrderOverrideDescriptiveText()
    {
        return $this->OrderOverrideDescriptiveText;
    }
    /**
     * Set OrderOverrideDescriptiveText value
     * @param string $orderOverrideDescriptiveText
     * @return \StructType\Order
     */
    public function setOrderOverrideDescriptiveText($orderOverrideDescriptiveText = null)
    {
        // validation for constraint: string
        if (!is_null($orderOverrideDescriptiveText) && !is_string($orderOverrideDescriptiveText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderOverrideDescriptiveText)), __LINE__);
        }
        $this->OrderOverrideDescriptiveText = $orderOverrideDescriptiveText;
        return $this;
    }
    /**
     * Get StoreOrderIDForEdit value
     * @return string|null
     */
    public function getStoreOrderIDForEdit()
    {
        return $this->StoreOrderIDForEdit;
    }
    /**
     * Set StoreOrderIDForEdit value
     * @param string $storeOrderIDForEdit
     * @return \StructType\Order
     */
    public function setStoreOrderIDForEdit($storeOrderIDForEdit = null)
    {
        // validation for constraint: string
        if (!is_null($storeOrderIDForEdit) && !is_string($storeOrderIDForEdit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($storeOrderIDForEdit)), __LINE__);
        }
        $this->StoreOrderIDForEdit = $storeOrderIDForEdit;
        return $this;
    }
    /**
     * Get OrderInfoCollection value
     * @return \StructType\OrderInfoCollection|null
     */
    public function getOrderInfoCollection()
    {
        return $this->OrderInfoCollection;
    }
    /**
     * Set OrderInfoCollection value
     * @param \StructType\OrderInfoCollection $orderInfoCollection
     * @return \StructType\Order
     */
    public function setOrderInfoCollection(\StructType\OrderInfoCollection $orderInfoCollection = null)
    {
        $this->OrderInfoCollection = $orderInfoCollection;
        return $this;
    }
    /**
     * Get IsExpedited value
     * @return bool|null
     */
    public function getIsExpedited()
    {
        return $this->IsExpedited;
    }
    /**
     * Set IsExpedited value
     * @param bool $isExpedited
     * @return \StructType\Order
     */
    public function setIsExpedited($isExpedited = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExpedited) && !is_bool($isExpedited)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isExpedited)), __LINE__);
        }
        $this->IsExpedited = $isExpedited;
        return $this;
    }
    /**
     * Get PendingOrder value
     * @return bool|null
     */
    public function getPendingOrder()
    {
        return $this->PendingOrder;
    }
    /**
     * Set PendingOrder value
     * @param bool $pendingOrder
     * @return \StructType\Order
     */
    public function setPendingOrder($pendingOrder = null)
    {
        // validation for constraint: boolean
        if (!is_null($pendingOrder) && !is_bool($pendingOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($pendingOrder)), __LINE__);
        }
        $this->PendingOrder = $pendingOrder;
        return $this;
    }
    /**
     * Get LoyaltyNumber value
     * @return string|null
     */
    public function getLoyaltyNumber()
    {
        return $this->LoyaltyNumber;
    }
    /**
     * Set LoyaltyNumber value
     * @param string $loyaltyNumber
     * @return \StructType\Order
     */
    public function setLoyaltyNumber($loyaltyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($loyaltyNumber) && !is_string($loyaltyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loyaltyNumber)), __LINE__);
        }
        $this->LoyaltyNumber = $loyaltyNumber;
        return $this;
    }
    /**
     * Get FundRaising value
     * @return string|null
     */
    public function getFundRaising()
    {
        return $this->FundRaising;
    }
    /**
     * Set FundRaising value
     * @param string $fundRaising
     * @return \StructType\Order
     */
    public function setFundRaising($fundRaising = null)
    {
        // validation for constraint: string
        if (!is_null($fundRaising) && !is_string($fundRaising)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fundRaising)), __LINE__);
        }
        $this->FundRaising = $fundRaising;
        return $this;
    }
    /**
     * Get OneTimeCustomerComment value
     * @return string|null
     */
    public function getOneTimeCustomerComment()
    {
        return $this->OneTimeCustomerComment;
    }
    /**
     * Set OneTimeCustomerComment value
     * @param string $oneTimeCustomerComment
     * @return \StructType\Order
     */
    public function setOneTimeCustomerComment($oneTimeCustomerComment = null)
    {
        // validation for constraint: string
        if (!is_null($oneTimeCustomerComment) && !is_string($oneTimeCustomerComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oneTimeCustomerComment)), __LINE__);
        }
        $this->OneTimeCustomerComment = $oneTimeCustomerComment;
        return $this;
    }
    /**
     * Get orderid value
     * @return string|null
     */
    public function getOrderid()
    {
        return $this->orderid;
    }
    /**
     * Set orderid value
     * @param string $orderid
     * @return \StructType\Order
     */
    public function setOrderid($orderid = null)
    {
        // validation for constraint: string
        if (!is_null($orderid) && !is_string($orderid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderid)), __LINE__);
        }
        $this->orderid = $orderid;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\Order
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\Order
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Order
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
