<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Language StructType
 * @subpackage Structs
 */
class Language extends AbstractStructBase
{
    /**
     * The LanguageCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LanguageCode;
    /**
     * The LanguageTextDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LanguageTextDescription;
    /**
     * The LanguageDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LanguageDescription;
    /**
     * The LanguageCulture
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LanguageCulture;
    /**
     * Constructor method for Language
     * @uses Language::setLanguageCode()
     * @uses Language::setLanguageTextDescription()
     * @uses Language::setLanguageDescription()
     * @uses Language::setLanguageCulture()
     * @param string $languageCode
     * @param string $languageTextDescription
     * @param string $languageDescription
     * @param string $languageCulture
     */
    public function __construct($languageCode = null, $languageTextDescription = null, $languageDescription = null, $languageCulture = null)
    {
        $this
            ->setLanguageCode($languageCode)
            ->setLanguageTextDescription($languageTextDescription)
            ->setLanguageDescription($languageDescription)
            ->setLanguageCulture($languageCulture);
    }
    /**
     * Get LanguageCode value
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }
    /**
     * Set LanguageCode value
     * @param string $languageCode
     * @return \StructType\Language
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languageCode)), __LINE__);
        }
        $this->LanguageCode = $languageCode;
        return $this;
    }
    /**
     * Get LanguageTextDescription value
     * @return string
     */
    public function getLanguageTextDescription()
    {
        return $this->LanguageTextDescription;
    }
    /**
     * Set LanguageTextDescription value
     * @param string $languageTextDescription
     * @return \StructType\Language
     */
    public function setLanguageTextDescription($languageTextDescription = null)
    {
        // validation for constraint: string
        if (!is_null($languageTextDescription) && !is_string($languageTextDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languageTextDescription)), __LINE__);
        }
        $this->LanguageTextDescription = $languageTextDescription;
        return $this;
    }
    /**
     * Get LanguageDescription value
     * @return string
     */
    public function getLanguageDescription()
    {
        return $this->LanguageDescription;
    }
    /**
     * Set LanguageDescription value
     * @param string $languageDescription
     * @return \StructType\Language
     */
    public function setLanguageDescription($languageDescription = null)
    {
        // validation for constraint: string
        if (!is_null($languageDescription) && !is_string($languageDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languageDescription)), __LINE__);
        }
        $this->LanguageDescription = $languageDescription;
        return $this;
    }
    /**
     * Get LanguageCulture value
     * @return string|null
     */
    public function getLanguageCulture()
    {
        return $this->LanguageCulture;
    }
    /**
     * Set LanguageCulture value
     * @param string $languageCulture
     * @return \StructType\Language
     */
    public function setLanguageCulture($languageCulture = null)
    {
        // validation for constraint: string
        if (!is_null($languageCulture) && !is_string($languageCulture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languageCulture)), __LINE__);
        }
        $this->LanguageCulture = $languageCulture;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Language
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
