<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Holiday StructType
 * @subpackage Structs
 */
class Holiday extends AbstractStructBase
{
    /**
     * The HolidayOpenTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HolidayOpenTime;
    /**
     * The HolidayCloseTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HolidayCloseTime;
    /**
     * The HolidayIsClosedAllDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HolidayIsClosedAllDay;
    /**
     * Constructor method for Holiday
     * @uses Holiday::setHolidayOpenTime()
     * @uses Holiday::setHolidayCloseTime()
     * @uses Holiday::setHolidayIsClosedAllDay()
     * @param string $holidayOpenTime
     * @param string $holidayCloseTime
     * @param string $holidayIsClosedAllDay
     */
    public function __construct($holidayOpenTime = null, $holidayCloseTime = null, $holidayIsClosedAllDay = null)
    {
        $this
            ->setHolidayOpenTime($holidayOpenTime)
            ->setHolidayCloseTime($holidayCloseTime)
            ->setHolidayIsClosedAllDay($holidayIsClosedAllDay);
    }
    /**
     * Get HolidayOpenTime value
     * @return string
     */
    public function getHolidayOpenTime()
    {
        return $this->HolidayOpenTime;
    }
    /**
     * Set HolidayOpenTime value
     * @param string $holidayOpenTime
     * @return \StructType\Holiday
     */
    public function setHolidayOpenTime($holidayOpenTime = null)
    {
        // validation for constraint: string
        if (!is_null($holidayOpenTime) && !is_string($holidayOpenTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($holidayOpenTime)), __LINE__);
        }
        $this->HolidayOpenTime = $holidayOpenTime;
        return $this;
    }
    /**
     * Get HolidayCloseTime value
     * @return string
     */
    public function getHolidayCloseTime()
    {
        return $this->HolidayCloseTime;
    }
    /**
     * Set HolidayCloseTime value
     * @param string $holidayCloseTime
     * @return \StructType\Holiday
     */
    public function setHolidayCloseTime($holidayCloseTime = null)
    {
        // validation for constraint: string
        if (!is_null($holidayCloseTime) && !is_string($holidayCloseTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($holidayCloseTime)), __LINE__);
        }
        $this->HolidayCloseTime = $holidayCloseTime;
        return $this;
    }
    /**
     * Get HolidayIsClosedAllDay value
     * @return string
     */
    public function getHolidayIsClosedAllDay()
    {
        return $this->HolidayIsClosedAllDay;
    }
    /**
     * Set HolidayIsClosedAllDay value
     * @param string $holidayIsClosedAllDay
     * @return \StructType\Holiday
     */
    public function setHolidayIsClosedAllDay($holidayIsClosedAllDay = null)
    {
        // validation for constraint: string
        if (!is_null($holidayIsClosedAllDay) && !is_string($holidayIsClosedAllDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($holidayIsClosedAllDay)), __LINE__);
        }
        $this->HolidayIsClosedAllDay = $holidayIsClosedAllDay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Holiday
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
