<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftCardPayment StructType
 * @subpackage Structs
 */
class GiftCardPayment extends AbstractStructBase
{
    /**
     * The GiftCardNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GiftCardNumber;
    /**
     * The PaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentAmount;
    /**
     * The BalanceInquiry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BalanceInquiry;
    /**
     * The CardBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardBalance;
    /**
     * The GiftCardToken
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GiftCardToken;
    /**
     * The PIN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PIN;
    /**
     * The IsPayLater
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsPayLater;
    /**
     * The TipAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipAmount;
    /**
     * Constructor method for GiftCardPayment
     * @uses GiftCardPayment::setGiftCardNumber()
     * @uses GiftCardPayment::setPaymentAmount()
     * @uses GiftCardPayment::setBalanceInquiry()
     * @uses GiftCardPayment::setCardBalance()
     * @uses GiftCardPayment::setGiftCardToken()
     * @uses GiftCardPayment::setPIN()
     * @uses GiftCardPayment::setIsPayLater()
     * @uses GiftCardPayment::setTipAmount()
     * @param string $giftCardNumber
     * @param string $paymentAmount
     * @param string $balanceInquiry
     * @param string $cardBalance
     * @param string $giftCardToken
     * @param string $pIN
     * @param bool $isPayLater
     * @param string $tipAmount
     */
    public function __construct($giftCardNumber = null, $paymentAmount = null, $balanceInquiry = null, $cardBalance = null, $giftCardToken = null, $pIN = null, $isPayLater = null, $tipAmount = null)
    {
        $this
            ->setGiftCardNumber($giftCardNumber)
            ->setPaymentAmount($paymentAmount)
            ->setBalanceInquiry($balanceInquiry)
            ->setCardBalance($cardBalance)
            ->setGiftCardToken($giftCardToken)
            ->setPIN($pIN)
            ->setIsPayLater($isPayLater)
            ->setTipAmount($tipAmount);
    }
    /**
     * Get GiftCardNumber value
     * @return string
     */
    public function getGiftCardNumber()
    {
        return $this->GiftCardNumber;
    }
    /**
     * Set GiftCardNumber value
     * @param string $giftCardNumber
     * @return \StructType\GiftCardPayment
     */
    public function setGiftCardNumber($giftCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftCardNumber) && !is_string($giftCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($giftCardNumber)), __LINE__);
        }
        $this->GiftCardNumber = $giftCardNumber;
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return string|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param string $paymentAmount
     * @return \StructType\GiftCardPayment
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: string
        if (!is_null($paymentAmount) && !is_string($paymentAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentAmount)), __LINE__);
        }
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get BalanceInquiry value
     * @return string|null
     */
    public function getBalanceInquiry()
    {
        return $this->BalanceInquiry;
    }
    /**
     * Set BalanceInquiry value
     * @param string $balanceInquiry
     * @return \StructType\GiftCardPayment
     */
    public function setBalanceInquiry($balanceInquiry = null)
    {
        // validation for constraint: string
        if (!is_null($balanceInquiry) && !is_string($balanceInquiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($balanceInquiry)), __LINE__);
        }
        $this->BalanceInquiry = $balanceInquiry;
        return $this;
    }
    /**
     * Get CardBalance value
     * @return string|null
     */
    public function getCardBalance()
    {
        return $this->CardBalance;
    }
    /**
     * Set CardBalance value
     * @param string $cardBalance
     * @return \StructType\GiftCardPayment
     */
    public function setCardBalance($cardBalance = null)
    {
        // validation for constraint: string
        if (!is_null($cardBalance) && !is_string($cardBalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardBalance)), __LINE__);
        }
        $this->CardBalance = $cardBalance;
        return $this;
    }
    /**
     * Get GiftCardToken value
     * @return string|null
     */
    public function getGiftCardToken()
    {
        return $this->GiftCardToken;
    }
    /**
     * Set GiftCardToken value
     * @param string $giftCardToken
     * @return \StructType\GiftCardPayment
     */
    public function setGiftCardToken($giftCardToken = null)
    {
        // validation for constraint: string
        if (!is_null($giftCardToken) && !is_string($giftCardToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($giftCardToken)), __LINE__);
        }
        $this->GiftCardToken = $giftCardToken;
        return $this;
    }
    /**
     * Get PIN value
     * @return string|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param string $pIN
     * @return \StructType\GiftCardPayment
     */
    public function setPIN($pIN = null)
    {
        // validation for constraint: string
        if (!is_null($pIN) && !is_string($pIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pIN)), __LINE__);
        }
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get IsPayLater value
     * @return bool|null
     */
    public function getIsPayLater()
    {
        return $this->IsPayLater;
    }
    /**
     * Set IsPayLater value
     * @param bool $isPayLater
     * @return \StructType\GiftCardPayment
     */
    public function setIsPayLater($isPayLater = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPayLater) && !is_bool($isPayLater)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPayLater)), __LINE__);
        }
        $this->IsPayLater = $isPayLater;
        return $this;
    }
    /**
     * Get TipAmount value
     * @return string|null
     */
    public function getTipAmount()
    {
        return $this->TipAmount;
    }
    /**
     * Set TipAmount value
     * @param string $tipAmount
     * @return \StructType\GiftCardPayment
     */
    public function setTipAmount($tipAmount = null)
    {
        // validation for constraint: string
        if (!is_null($tipAmount) && !is_string($tipAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipAmount)), __LINE__);
        }
        $this->TipAmount = $tipAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GiftCardPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
