<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Day StructType
 * @subpackage Structs
 */
class Day extends AbstractStructBase
{
    /**
     * The OpenTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OpenTime;
    /**
     * The CloseTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CloseTime;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * Constructor method for Day
     * @uses Day::setOpenTime()
     * @uses Day::setCloseTime()
     * @uses Day::setName()
     * @param string $openTime
     * @param string $closeTime
     * @param string $name
     */
    public function __construct($openTime = null, $closeTime = null, $name = null)
    {
        $this
            ->setOpenTime($openTime)
            ->setCloseTime($closeTime)
            ->setName($name);
    }
    /**
     * Get OpenTime value
     * @return string
     */
    public function getOpenTime()
    {
        return $this->OpenTime;
    }
    /**
     * Set OpenTime value
     * @param string $openTime
     * @return \StructType\Day
     */
    public function setOpenTime($openTime = null)
    {
        // validation for constraint: string
        if (!is_null($openTime) && !is_string($openTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($openTime)), __LINE__);
        }
        $this->OpenTime = $openTime;
        return $this;
    }
    /**
     * Get CloseTime value
     * @return string
     */
    public function getCloseTime()
    {
        return $this->CloseTime;
    }
    /**
     * Set CloseTime value
     * @param string $closeTime
     * @return \StructType\Day
     */
    public function setCloseTime($closeTime = null)
    {
        // validation for constraint: string
        if (!is_null($closeTime) && !is_string($closeTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($closeTime)), __LINE__);
        }
        $this->CloseTime = $closeTime;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Day
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Day
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
