<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customer StructType
 * @subpackage Structs
 */
class Customer extends AbstractStructBase
{
    /**
     * The CustomerAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CustomerAddress
     */
    public $CustomerAddress;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Name
     */
    public $Name;
    /**
     * The CustomerTypeInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CustomerTypeInfo
     */
    public $CustomerTypeInfo;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Extension
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Extension;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The DeliveryInstructions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryInstructions;
    /**
     * The CustomerTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerTax;
    /**
     * The LoyaltyNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoyaltyNumber;
    /**
     * The CustomerNameKana
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNameKana;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * Constructor method for Customer
     * @uses Customer::setCustomerAddress()
     * @uses Customer::setName()
     * @uses Customer::setCustomerTypeInfo()
     * @uses Customer::setPhone()
     * @uses Customer::setExtension()
     * @uses Customer::setEmail()
     * @uses Customer::setDeliveryInstructions()
     * @uses Customer::setCustomerTax()
     * @uses Customer::setLoyaltyNumber()
     * @uses Customer::setCustomerNameKana()
     * @uses Customer::setType()
     * @param \StructType\CustomerAddress $customerAddress
     * @param \StructType\Name $name
     * @param \StructType\CustomerTypeInfo $customerTypeInfo
     * @param string $phone
     * @param string $extension
     * @param string $email
     * @param string $deliveryInstructions
     * @param string $customerTax
     * @param string $loyaltyNumber
     * @param string $customerNameKana
     * @param string $type
     */
    public function __construct(\StructType\CustomerAddress $customerAddress = null, \StructType\Name $name = null, \StructType\CustomerTypeInfo $customerTypeInfo = null, $phone = null, $extension = null, $email = null, $deliveryInstructions = null, $customerTax = null, $loyaltyNumber = null, $customerNameKana = null, $type = null)
    {
        $this
            ->setCustomerAddress($customerAddress)
            ->setName($name)
            ->setCustomerTypeInfo($customerTypeInfo)
            ->setPhone($phone)
            ->setExtension($extension)
            ->setEmail($email)
            ->setDeliveryInstructions($deliveryInstructions)
            ->setCustomerTax($customerTax)
            ->setLoyaltyNumber($loyaltyNumber)
            ->setCustomerNameKana($customerNameKana)
            ->setType($type);
    }
    /**
     * Get CustomerAddress value
     * @return \StructType\CustomerAddress
     */
    public function getCustomerAddress()
    {
        return $this->CustomerAddress;
    }
    /**
     * Set CustomerAddress value
     * @param \StructType\CustomerAddress $customerAddress
     * @return \StructType\Customer
     */
    public function setCustomerAddress(\StructType\CustomerAddress $customerAddress = null)
    {
        $this->CustomerAddress = $customerAddress;
        return $this;
    }
    /**
     * Get Name value
     * @return \StructType\Name
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\Name $name
     * @return \StructType\Customer
     */
    public function setName(\StructType\Name $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get CustomerTypeInfo value
     * @return \StructType\CustomerTypeInfo
     */
    public function getCustomerTypeInfo()
    {
        return $this->CustomerTypeInfo;
    }
    /**
     * Set CustomerTypeInfo value
     * @param \StructType\CustomerTypeInfo $customerTypeInfo
     * @return \StructType\Customer
     */
    public function setCustomerTypeInfo(\StructType\CustomerTypeInfo $customerTypeInfo = null)
    {
        $this->CustomerTypeInfo = $customerTypeInfo;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\Customer
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->Extension;
    }
    /**
     * Set Extension value
     * @param string $extension
     * @return \StructType\Customer
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extension)), __LINE__);
        }
        $this->Extension = $extension;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Customer
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get DeliveryInstructions value
     * @return string|null
     */
    public function getDeliveryInstructions()
    {
        return $this->DeliveryInstructions;
    }
    /**
     * Set DeliveryInstructions value
     * @param string $deliveryInstructions
     * @return \StructType\Customer
     */
    public function setDeliveryInstructions($deliveryInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryInstructions) && !is_string($deliveryInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryInstructions)), __LINE__);
        }
        $this->DeliveryInstructions = $deliveryInstructions;
        return $this;
    }
    /**
     * Get CustomerTax value
     * @return string|null
     */
    public function getCustomerTax()
    {
        return $this->CustomerTax;
    }
    /**
     * Set CustomerTax value
     * @param string $customerTax
     * @return \StructType\Customer
     */
    public function setCustomerTax($customerTax = null)
    {
        // validation for constraint: string
        if (!is_null($customerTax) && !is_string($customerTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerTax)), __LINE__);
        }
        $this->CustomerTax = $customerTax;
        return $this;
    }
    /**
     * Get LoyaltyNumber value
     * @return string|null
     */
    public function getLoyaltyNumber()
    {
        return $this->LoyaltyNumber;
    }
    /**
     * Set LoyaltyNumber value
     * @param string $loyaltyNumber
     * @return \StructType\Customer
     */
    public function setLoyaltyNumber($loyaltyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($loyaltyNumber) && !is_string($loyaltyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loyaltyNumber)), __LINE__);
        }
        $this->LoyaltyNumber = $loyaltyNumber;
        return $this;
    }
    /**
     * Get CustomerNameKana value
     * @return string|null
     */
    public function getCustomerNameKana()
    {
        return $this->CustomerNameKana;
    }
    /**
     * Set CustomerNameKana value
     * @param string $customerNameKana
     * @return \StructType\Customer
     */
    public function setCustomerNameKana($customerNameKana = null)
    {
        // validation for constraint: string
        if (!is_null($customerNameKana) && !is_string($customerNameKana)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerNameKana)), __LINE__);
        }
        $this->CustomerNameKana = $customerNameKana;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\Customer
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Customer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
