<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CouponGroup StructType
 * @subpackage Structs
 */
class CouponGroup extends AbstractStructBase
{
    /**
     * The CouponGroupCode
     * @var string
     */
    public $CouponGroupCode;
    /**
     * The CouponGroupDescription
     * @var string
     */
    public $CouponGroupDescription;
    /**
     * Constructor method for CouponGroup
     * @uses CouponGroup::setCouponGroupCode()
     * @uses CouponGroup::setCouponGroupDescription()
     * @param string $couponGroupCode
     * @param string $couponGroupDescription
     */
    public function __construct($couponGroupCode = null, $couponGroupDescription = null)
    {
        $this
            ->setCouponGroupCode($couponGroupCode)
            ->setCouponGroupDescription($couponGroupDescription);
    }
    /**
     * Get CouponGroupCode value
     * @return string|null
     */
    public function getCouponGroupCode()
    {
        return $this->CouponGroupCode;
    }
    /**
     * Set CouponGroupCode value
     * @param string $couponGroupCode
     * @return \StructType\CouponGroup
     */
    public function setCouponGroupCode($couponGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($couponGroupCode) && !is_string($couponGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($couponGroupCode)), __LINE__);
        }
        $this->CouponGroupCode = $couponGroupCode;
        return $this;
    }
    /**
     * Get CouponGroupDescription value
     * @return string|null
     */
    public function getCouponGroupDescription()
    {
        return $this->CouponGroupDescription;
    }
    /**
     * Set CouponGroupDescription value
     * @param string $couponGroupDescription
     * @return \StructType\CouponGroup
     */
    public function setCouponGroupDescription($couponGroupDescription = null)
    {
        // validation for constraint: string
        if (!is_null($couponGroupDescription) && !is_string($couponGroupDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($couponGroupDescription)), __LINE__);
        }
        $this->CouponGroupDescription = $couponGroupDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CouponGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
