<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckPayment StructType
 * @subpackage Structs
 */
class CheckPayment extends AbstractStructBase
{
    /**
     * The PaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentAmount;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The RoutingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoutingNumber;
    /**
     * The CheckNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckNumber;
    /**
     * The IsPayLater
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsPayLater;
    /**
     * The TipAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipAmount;
    /**
     * Constructor method for CheckPayment
     * @uses CheckPayment::setPaymentAmount()
     * @uses CheckPayment::setAccountNumber()
     * @uses CheckPayment::setRoutingNumber()
     * @uses CheckPayment::setCheckNumber()
     * @uses CheckPayment::setIsPayLater()
     * @uses CheckPayment::setTipAmount()
     * @param string $paymentAmount
     * @param string $accountNumber
     * @param string $routingNumber
     * @param string $checkNumber
     * @param bool $isPayLater
     * @param string $tipAmount
     */
    public function __construct($paymentAmount = null, $accountNumber = null, $routingNumber = null, $checkNumber = null, $isPayLater = null, $tipAmount = null)
    {
        $this
            ->setPaymentAmount($paymentAmount)
            ->setAccountNumber($accountNumber)
            ->setRoutingNumber($routingNumber)
            ->setCheckNumber($checkNumber)
            ->setIsPayLater($isPayLater)
            ->setTipAmount($tipAmount);
    }
    /**
     * Get PaymentAmount value
     * @return string|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param string $paymentAmount
     * @return \StructType\CheckPayment
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: string
        if (!is_null($paymentAmount) && !is_string($paymentAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentAmount)), __LINE__);
        }
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\CheckPayment
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get RoutingNumber value
     * @return string|null
     */
    public function getRoutingNumber()
    {
        return $this->RoutingNumber;
    }
    /**
     * Set RoutingNumber value
     * @param string $routingNumber
     * @return \StructType\CheckPayment
     */
    public function setRoutingNumber($routingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($routingNumber) && !is_string($routingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routingNumber)), __LINE__);
        }
        $this->RoutingNumber = $routingNumber;
        return $this;
    }
    /**
     * Get CheckNumber value
     * @return string|null
     */
    public function getCheckNumber()
    {
        return $this->CheckNumber;
    }
    /**
     * Set CheckNumber value
     * @param string $checkNumber
     * @return \StructType\CheckPayment
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkNumber) && !is_string($checkNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkNumber)), __LINE__);
        }
        $this->CheckNumber = $checkNumber;
        return $this;
    }
    /**
     * Get IsPayLater value
     * @return bool|null
     */
    public function getIsPayLater()
    {
        return $this->IsPayLater;
    }
    /**
     * Set IsPayLater value
     * @param bool $isPayLater
     * @return \StructType\CheckPayment
     */
    public function setIsPayLater($isPayLater = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPayLater) && !is_bool($isPayLater)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPayLater)), __LINE__);
        }
        $this->IsPayLater = $isPayLater;
        return $this;
    }
    /**
     * Get TipAmount value
     * @return string|null
     */
    public function getTipAmount()
    {
        return $this->TipAmount;
    }
    /**
     * Set TipAmount value
     * @param string $tipAmount
     * @return \StructType\CheckPayment
     */
    public function setTipAmount($tipAmount = null)
    {
        // validation for constraint: string
        if (!is_null($tipAmount) && !is_string($tipAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipAmount)), __LINE__);
        }
        $this->TipAmount = $tipAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
