<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CashPayment StructType
 * @subpackage Structs
 */
class CashPayment extends AbstractStructBase
{
    /**
     * The PaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentAmount;
    /**
     * The IsPayLater
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsPayLater;
    /**
     * The TipAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipAmount;
    /**
     * Constructor method for CashPayment
     * @uses CashPayment::setPaymentAmount()
     * @uses CashPayment::setIsPayLater()
     * @uses CashPayment::setTipAmount()
     * @param string $paymentAmount
     * @param bool $isPayLater
     * @param string $tipAmount
     */
    public function __construct($paymentAmount = null, $isPayLater = null, $tipAmount = null)
    {
        $this
            ->setPaymentAmount($paymentAmount)
            ->setIsPayLater($isPayLater)
            ->setTipAmount($tipAmount);
    }
    /**
     * Get PaymentAmount value
     * @return string|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param string $paymentAmount
     * @return \StructType\CashPayment
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: string
        if (!is_null($paymentAmount) && !is_string($paymentAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentAmount)), __LINE__);
        }
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get IsPayLater value
     * @return bool|null
     */
    public function getIsPayLater()
    {
        return $this->IsPayLater;
    }
    /**
     * Set IsPayLater value
     * @param bool $isPayLater
     * @return \StructType\CashPayment
     */
    public function setIsPayLater($isPayLater = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPayLater) && !is_bool($isPayLater)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPayLater)), __LINE__);
        }
        $this->IsPayLater = $isPayLater;
        return $this;
    }
    /**
     * Get TipAmount value
     * @return string|null
     */
    public function getTipAmount()
    {
        return $this->TipAmount;
    }
    /**
     * Set TipAmount value
     * @param string $tipAmount
     * @return \StructType\CashPayment
     */
    public function setTipAmount($tipAmount = null)
    {
        // validation for constraint: string
        if (!is_null($tipAmount) && !is_string($tipAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipAmount)), __LINE__);
        }
        $this->TipAmount = $tipAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CashPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
