<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardType StructType
 * @subpackage Structs
 */
class CardType extends AbstractStructBase
{
    /**
     * The CardTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CardTypeID;
    /**
     * The CardTypeDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CardTypeDescription;
    /**
     * Constructor method for CardType
     * @uses CardType::setCardTypeID()
     * @uses CardType::setCardTypeDescription()
     * @param string $cardTypeID
     * @param string $cardTypeDescription
     */
    public function __construct($cardTypeID = null, $cardTypeDescription = null)
    {
        $this
            ->setCardTypeID($cardTypeID)
            ->setCardTypeDescription($cardTypeDescription);
    }
    /**
     * Get CardTypeID value
     * @return string
     */
    public function getCardTypeID()
    {
        return $this->CardTypeID;
    }
    /**
     * Set CardTypeID value
     * @param string $cardTypeID
     * @return \StructType\CardType
     */
    public function setCardTypeID($cardTypeID = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeID) && !is_string($cardTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardTypeID)), __LINE__);
        }
        $this->CardTypeID = $cardTypeID;
        return $this;
    }
    /**
     * Get CardTypeDescription value
     * @return string
     */
    public function getCardTypeDescription()
    {
        return $this->CardTypeDescription;
    }
    /**
     * Set CardTypeDescription value
     * @param string $cardTypeDescription
     * @return \StructType\CardType
     */
    public function setCardTypeDescription($cardTypeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeDescription) && !is_string($cardTypeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardTypeDescription)), __LINE__);
        }
        $this->CardTypeDescription = $cardTypeDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CardType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
