<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptableCardTypeIDs StructType
 * @subpackage Structs
 */
class AcceptableCardTypeIDs extends AbstractStructBase
{
    /**
     * The CardType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 20
     * - minOccurs: 1
     * @var \StructType\CardType[]
     */
    public $CardType;
    /**
     * Constructor method for AcceptableCardTypeIDs
     * @uses AcceptableCardTypeIDs::setCardType()
     * @param \StructType\CardType[] $cardType
     */
    public function __construct(array $cardType = array())
    {
        $this
            ->setCardType($cardType);
    }
    /**
     * Get CardType value
     * @return \StructType\CardType[]
     */
    public function getCardType()
    {
        return $this->CardType;
    }
    /**
     * Set CardType value
     * @throws \InvalidArgumentException
     * @param \StructType\CardType[] $cardType
     * @return \StructType\AcceptableCardTypeIDs
     */
    public function setCardType(array $cardType = array())
    {
        foreach ($cardType as $acceptableCardTypeIDsCardTypeItem) {
            // validation for constraint: itemType
            if (!$acceptableCardTypeIDsCardTypeItem instanceof \StructType\CardType) {
                throw new \InvalidArgumentException(sprintf('The CardType property can only contain items of \StructType\CardType, "%s" given', is_object($acceptableCardTypeIDsCardTypeItem) ? get_class($acceptableCardTypeIDsCardTypeItem) : gettype($acceptableCardTypeIDsCardTypeItem)), __LINE__);
            }
        }
        $this->CardType = $cardType;
        return $this;
    }
    /**
     * Add item to CardType value
     * @throws \InvalidArgumentException
     * @param \StructType\CardType $item
     * @return \StructType\AcceptableCardTypeIDs
     */
    public function addToCardType(\StructType\CardType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CardType) {
            throw new \InvalidArgumentException(sprintf('The CardType property can only contain items of \StructType\CardType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CardType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AcceptableCardTypeIDs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
