<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetOrderStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $storeID
     * @param string $storeOrderID
     * @param string $endUserIPAddress
     * @param string $powerServerIPAddress
     * @return \StructType\OrderReply|bool
     */
    public function GetOrderStatus($storeID, $storeOrderID, $endUserIPAddress, $powerServerIPAddress)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOrderStatus($storeID, $storeOrderID, $endUserIPAddress, $powerServerIPAddress));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderStatuses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $storeID
     * @param string $businessDate
     * @param string $asOfTime
     * @return \StructType\OrderStatuses|bool
     */
    public function GetOrderStatuses($storeID, $businessDate, $asOfTime)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOrderStatuses($storeID, $businessDate, $asOfTime));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderStatusViaOrderID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $storeID
     * @param string $orderID
     * @param string $endUserIPAddress
     * @param string $powerServerIPAddress
     * @return \StructType\OrderReply|bool
     */
    public function GetOrderStatusViaOrderID($storeID, $orderID, $endUserIPAddress, $powerServerIPAddress)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOrderStatusViaOrderID($storeID, $orderID, $endUserIPAddress, $powerServerIPAddress));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStoreInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $storeID
     * @return \StructType\StoreInformation|bool
     */
    public function GetStoreInformation($storeID)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStoreInformation($storeID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStoreProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $storeID
     * @return \StructType\StoreProducts|bool
     */
    public function GetStoreProducts($storeID)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStoreProducts($storeID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllStoreProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $storeID
     * @return \StructType\StoreProducts|bool
     */
    public function GetAllStoreProducts($storeID)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllStoreProducts($storeID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStoreCustomers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $storeID
     * @return \StructType\StoreCustomers|bool
     */
    public function GetStoreCustomers($storeID)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStoreCustomers($storeID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStoreCoupons
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $storeID
     * @return \StructType\StoreCoupons|bool
     */
    public function GetStoreCoupons($storeID)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStoreCoupons($storeID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllStoreCoupons
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $storeID
     * @return \StructType\StoreCoupons|bool
     */
    public function GetAllStoreCoupons($storeID)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllStoreCoupons($storeID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStoreStreets
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $storeID
     * @param string $allStreets
     * @return array|bool
     */
    public function GetStoreStreets($storeID, $allStreets)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStoreStreets($storeID, $allStreets));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array|\StructType\OrderReply|\StructType\OrderStatuses|\StructType\StoreCoupons|\StructType\StoreCustomers|\StructType\StoreInformation|\StructType\StoreProducts
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
