<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $storeID
     * @param string $storeOrderID
     * @param string $reason
     * @param string $endUserIPAddress
     * @param string $powerServerIPAddress
     * @return \StructType\OrderReply|bool
     */
    public function CancelOrder($storeID, $storeOrderID, $reason, $endUserIPAddress, $powerServerIPAddress)
    {
        try {
            $this->setResult(self::getSoapClient()->CancelOrder($storeID, $storeOrderID, $reason, $endUserIPAddress, $powerServerIPAddress));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelOrderViaOrderID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $storeID
     * @param string $orderID
     * @param string $reason
     * @param string $endUserIPAddress
     * @param string $powerServerIPAddress
     * @return \StructType\OrderReply|bool
     */
    public function CancelOrderViaOrderID($storeID, $orderID, $reason, $endUserIPAddress, $powerServerIPAddress)
    {
        try {
            $this->setResult(self::getSoapClient()->CancelOrderViaOrderID($storeID, $orderID, $reason, $endUserIPAddress, $powerServerIPAddress));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OrderReply
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
