<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidProductFilter StructType
 * @subpackage Structs
 */
class ValidProductFilter extends AbstractStructBase
{
    /**
     * The ValidCategoryCode
     * @var string
     */
    public $ValidCategoryCode;
    /**
     * The ValidSizeCode
     * @var string
     */
    public $ValidSizeCode;
    /**
     * The ValidFlavorCode
     * @var string
     */
    public $ValidFlavorCode;
    /**
     * The ValidOSGTypeCode
     * @var string
     */
    public $ValidOSGTypeCode;
    /**
     * Constructor method for ValidProductFilter
     * @uses ValidProductFilter::setValidCategoryCode()
     * @uses ValidProductFilter::setValidSizeCode()
     * @uses ValidProductFilter::setValidFlavorCode()
     * @uses ValidProductFilter::setValidOSGTypeCode()
     * @param string $validCategoryCode
     * @param string $validSizeCode
     * @param string $validFlavorCode
     * @param string $validOSGTypeCode
     */
    public function __construct($validCategoryCode = null, $validSizeCode = null, $validFlavorCode = null, $validOSGTypeCode = null)
    {
        $this
            ->setValidCategoryCode($validCategoryCode)
            ->setValidSizeCode($validSizeCode)
            ->setValidFlavorCode($validFlavorCode)
            ->setValidOSGTypeCode($validOSGTypeCode);
    }
    /**
     * Get ValidCategoryCode value
     * @return string|null
     */
    public function getValidCategoryCode()
    {
        return $this->ValidCategoryCode;
    }
    /**
     * Set ValidCategoryCode value
     * @param string $validCategoryCode
     * @return \StructType\ValidProductFilter
     */
    public function setValidCategoryCode($validCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($validCategoryCode) && !is_string($validCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validCategoryCode)), __LINE__);
        }
        $this->ValidCategoryCode = $validCategoryCode;
        return $this;
    }
    /**
     * Get ValidSizeCode value
     * @return string|null
     */
    public function getValidSizeCode()
    {
        return $this->ValidSizeCode;
    }
    /**
     * Set ValidSizeCode value
     * @param string $validSizeCode
     * @return \StructType\ValidProductFilter
     */
    public function setValidSizeCode($validSizeCode = null)
    {
        // validation for constraint: string
        if (!is_null($validSizeCode) && !is_string($validSizeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validSizeCode)), __LINE__);
        }
        $this->ValidSizeCode = $validSizeCode;
        return $this;
    }
    /**
     * Get ValidFlavorCode value
     * @return string|null
     */
    public function getValidFlavorCode()
    {
        return $this->ValidFlavorCode;
    }
    /**
     * Set ValidFlavorCode value
     * @param string $validFlavorCode
     * @return \StructType\ValidProductFilter
     */
    public function setValidFlavorCode($validFlavorCode = null)
    {
        // validation for constraint: string
        if (!is_null($validFlavorCode) && !is_string($validFlavorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validFlavorCode)), __LINE__);
        }
        $this->ValidFlavorCode = $validFlavorCode;
        return $this;
    }
    /**
     * Get ValidOSGTypeCode value
     * @return string|null
     */
    public function getValidOSGTypeCode()
    {
        return $this->ValidOSGTypeCode;
    }
    /**
     * Set ValidOSGTypeCode value
     * @param string $validOSGTypeCode
     * @return \StructType\ValidProductFilter
     */
    public function setValidOSGTypeCode($validOSGTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($validOSGTypeCode) && !is_string($validOSGTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validOSGTypeCode)), __LINE__);
        }
        $this->ValidOSGTypeCode = $validOSGTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidProductFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
