<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxStructure StructType
 * @subpackage Structs
 */
class TaxStructure extends AbstractStructBase
{
    /**
     * The TaxIncludedInPrices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TaxIncludedInPrices;
    /**
     * The TaxBoundary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TaxBoundary;
    /**
     * The TaxMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TaxMethod;
    /**
     * The TaxMethodDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TaxMethodDescription;
    /**
     * The TaxLimit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TaxLimit;
    /**
     * The TaxRates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TaxRates
     */
    public $TaxRates;
    /**
     * Constructor method for TaxStructure
     * @uses TaxStructure::setTaxIncludedInPrices()
     * @uses TaxStructure::setTaxBoundary()
     * @uses TaxStructure::setTaxMethod()
     * @uses TaxStructure::setTaxMethodDescription()
     * @uses TaxStructure::setTaxLimit()
     * @uses TaxStructure::setTaxRates()
     * @param string $taxIncludedInPrices
     * @param string $taxBoundary
     * @param string $taxMethod
     * @param string $taxMethodDescription
     * @param string $taxLimit
     * @param \StructType\TaxRates $taxRates
     */
    public function __construct($taxIncludedInPrices = null, $taxBoundary = null, $taxMethod = null, $taxMethodDescription = null, $taxLimit = null, \StructType\TaxRates $taxRates = null)
    {
        $this
            ->setTaxIncludedInPrices($taxIncludedInPrices)
            ->setTaxBoundary($taxBoundary)
            ->setTaxMethod($taxMethod)
            ->setTaxMethodDescription($taxMethodDescription)
            ->setTaxLimit($taxLimit)
            ->setTaxRates($taxRates);
    }
    /**
     * Get TaxIncludedInPrices value
     * @return string
     */
    public function getTaxIncludedInPrices()
    {
        return $this->TaxIncludedInPrices;
    }
    /**
     * Set TaxIncludedInPrices value
     * @param string $taxIncludedInPrices
     * @return \StructType\TaxStructure
     */
    public function setTaxIncludedInPrices($taxIncludedInPrices = null)
    {
        // validation for constraint: string
        if (!is_null($taxIncludedInPrices) && !is_string($taxIncludedInPrices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxIncludedInPrices)), __LINE__);
        }
        $this->TaxIncludedInPrices = $taxIncludedInPrices;
        return $this;
    }
    /**
     * Get TaxBoundary value
     * @return string
     */
    public function getTaxBoundary()
    {
        return $this->TaxBoundary;
    }
    /**
     * Set TaxBoundary value
     * @param string $taxBoundary
     * @return \StructType\TaxStructure
     */
    public function setTaxBoundary($taxBoundary = null)
    {
        // validation for constraint: string
        if (!is_null($taxBoundary) && !is_string($taxBoundary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxBoundary)), __LINE__);
        }
        $this->TaxBoundary = $taxBoundary;
        return $this;
    }
    /**
     * Get TaxMethod value
     * @return string
     */
    public function getTaxMethod()
    {
        return $this->TaxMethod;
    }
    /**
     * Set TaxMethod value
     * @param string $taxMethod
     * @return \StructType\TaxStructure
     */
    public function setTaxMethod($taxMethod = null)
    {
        // validation for constraint: string
        if (!is_null($taxMethod) && !is_string($taxMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxMethod)), __LINE__);
        }
        $this->TaxMethod = $taxMethod;
        return $this;
    }
    /**
     * Get TaxMethodDescription value
     * @return string
     */
    public function getTaxMethodDescription()
    {
        return $this->TaxMethodDescription;
    }
    /**
     * Set TaxMethodDescription value
     * @param string $taxMethodDescription
     * @return \StructType\TaxStructure
     */
    public function setTaxMethodDescription($taxMethodDescription = null)
    {
        // validation for constraint: string
        if (!is_null($taxMethodDescription) && !is_string($taxMethodDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxMethodDescription)), __LINE__);
        }
        $this->TaxMethodDescription = $taxMethodDescription;
        return $this;
    }
    /**
     * Get TaxLimit value
     * @return string
     */
    public function getTaxLimit()
    {
        return $this->TaxLimit;
    }
    /**
     * Set TaxLimit value
     * @param string $taxLimit
     * @return \StructType\TaxStructure
     */
    public function setTaxLimit($taxLimit = null)
    {
        // validation for constraint: string
        if (!is_null($taxLimit) && !is_string($taxLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxLimit)), __LINE__);
        }
        $this->TaxLimit = $taxLimit;
        return $this;
    }
    /**
     * Get TaxRates value
     * @return \StructType\TaxRates|null
     */
    public function getTaxRates()
    {
        return $this->TaxRates;
    }
    /**
     * Set TaxRates value
     * @param \StructType\TaxRates $taxRates
     * @return \StructType\TaxStructure
     */
    public function setTaxRates(\StructType\TaxRates $taxRates = null)
    {
        $this->TaxRates = $taxRates;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
