<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoreStreets StructType
 * @subpackage Structs
 */
class StoreStreets extends AbstractStructBase
{
    /**
     * The StoreID
     * @var string
     */
    public $StoreID;
    /**
     * The StreetList
     * @var string
     */
    public $StreetList;
    /**
     * The DeliveryRestrictionList
     * @var string
     */
    public $DeliveryRestrictionList;
    /**
     * Constructor method for StoreStreets
     * @uses StoreStreets::setStoreID()
     * @uses StoreStreets::setStreetList()
     * @uses StoreStreets::setDeliveryRestrictionList()
     * @param string $storeID
     * @param string $streetList
     * @param string $deliveryRestrictionList
     */
    public function __construct($storeID = null, $streetList = null, $deliveryRestrictionList = null)
    {
        $this
            ->setStoreID($storeID)
            ->setStreetList($streetList)
            ->setDeliveryRestrictionList($deliveryRestrictionList);
    }
    /**
     * Get StoreID value
     * @return string|null
     */
    public function getStoreID()
    {
        return $this->StoreID;
    }
    /**
     * Set StoreID value
     * @param string $storeID
     * @return \StructType\StoreStreets
     */
    public function setStoreID($storeID = null)
    {
        // validation for constraint: string
        if (!is_null($storeID) && !is_string($storeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($storeID)), __LINE__);
        }
        $this->StoreID = $storeID;
        return $this;
    }
    /**
     * Get StreetList value
     * @return string|null
     */
    public function getStreetList()
    {
        return $this->StreetList;
    }
    /**
     * Set StreetList value
     * @param string $streetList
     * @return \StructType\StoreStreets
     */
    public function setStreetList($streetList = null)
    {
        // validation for constraint: string
        if (!is_null($streetList) && !is_string($streetList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetList)), __LINE__);
        }
        $this->StreetList = $streetList;
        return $this;
    }
    /**
     * Get DeliveryRestrictionList value
     * @return string|null
     */
    public function getDeliveryRestrictionList()
    {
        return $this->DeliveryRestrictionList;
    }
    /**
     * Set DeliveryRestrictionList value
     * @param string $deliveryRestrictionList
     * @return \StructType\StoreStreets
     */
    public function setDeliveryRestrictionList($deliveryRestrictionList = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryRestrictionList) && !is_string($deliveryRestrictionList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryRestrictionList)), __LINE__);
        }
        $this->DeliveryRestrictionList = $deliveryRestrictionList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoreStreets
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
