<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoreService StructType
 * @subpackage Structs
 */
class StoreService extends AbstractStructBase
{
    /**
     * The IsOpen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IsOpen;
    /**
     * The IsElectronicOrderAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IsElectronicOrderAllowed;
    /**
     * Constructor method for StoreService
     * @uses StoreService::setIsOpen()
     * @uses StoreService::setIsElectronicOrderAllowed()
     * @param string $isOpen
     * @param string $isElectronicOrderAllowed
     */
    public function __construct($isOpen = null, $isElectronicOrderAllowed = null)
    {
        $this
            ->setIsOpen($isOpen)
            ->setIsElectronicOrderAllowed($isElectronicOrderAllowed);
    }
    /**
     * Get IsOpen value
     * @return string
     */
    public function getIsOpen()
    {
        return $this->IsOpen;
    }
    /**
     * Set IsOpen value
     * @param string $isOpen
     * @return \StructType\StoreService
     */
    public function setIsOpen($isOpen = null)
    {
        // validation for constraint: string
        if (!is_null($isOpen) && !is_string($isOpen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isOpen)), __LINE__);
        }
        $this->IsOpen = $isOpen;
        return $this;
    }
    /**
     * Get IsElectronicOrderAllowed value
     * @return string
     */
    public function getIsElectronicOrderAllowed()
    {
        return $this->IsElectronicOrderAllowed;
    }
    /**
     * Set IsElectronicOrderAllowed value
     * @param string $isElectronicOrderAllowed
     * @return \StructType\StoreService
     */
    public function setIsElectronicOrderAllowed($isElectronicOrderAllowed = null)
    {
        // validation for constraint: string
        if (!is_null($isElectronicOrderAllowed) && !is_string($isElectronicOrderAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isElectronicOrderAllowed)), __LINE__);
        }
        $this->IsElectronicOrderAllowed = $isElectronicOrderAllowed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoreService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
