<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoreSchedule StructType
 * @subpackage Structs
 */
class StoreSchedule extends AbstractStructBase
{
    /**
     * The TimeZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TimeZone;
    /**
     * The IsAffectedByDaylightSavingsTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IsAffectedByDaylightSavingsTime;
    /**
     * The Holidays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Holidays
     */
    public $Holidays;
    /**
     * The HoursOfOperation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HoursOfOperation
     */
    public $HoursOfOperation;
    /**
     * Constructor method for StoreSchedule
     * @uses StoreSchedule::setTimeZone()
     * @uses StoreSchedule::setIsAffectedByDaylightSavingsTime()
     * @uses StoreSchedule::setHolidays()
     * @uses StoreSchedule::setHoursOfOperation()
     * @param string $timeZone
     * @param string $isAffectedByDaylightSavingsTime
     * @param \StructType\Holidays $holidays
     * @param \StructType\HoursOfOperation $hoursOfOperation
     */
    public function __construct($timeZone = null, $isAffectedByDaylightSavingsTime = null, \StructType\Holidays $holidays = null, \StructType\HoursOfOperation $hoursOfOperation = null)
    {
        $this
            ->setTimeZone($timeZone)
            ->setIsAffectedByDaylightSavingsTime($isAffectedByDaylightSavingsTime)
            ->setHolidays($holidays)
            ->setHoursOfOperation($hoursOfOperation);
    }
    /**
     * Get TimeZone value
     * @return string
     */
    public function getTimeZone()
    {
        return $this->TimeZone;
    }
    /**
     * Set TimeZone value
     * @param string $timeZone
     * @return \StructType\StoreSchedule
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: string
        if (!is_null($timeZone) && !is_string($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeZone)), __LINE__);
        }
        $this->TimeZone = $timeZone;
        return $this;
    }
    /**
     * Get IsAffectedByDaylightSavingsTime value
     * @return string
     */
    public function getIsAffectedByDaylightSavingsTime()
    {
        return $this->IsAffectedByDaylightSavingsTime;
    }
    /**
     * Set IsAffectedByDaylightSavingsTime value
     * @param string $isAffectedByDaylightSavingsTime
     * @return \StructType\StoreSchedule
     */
    public function setIsAffectedByDaylightSavingsTime($isAffectedByDaylightSavingsTime = null)
    {
        // validation for constraint: string
        if (!is_null($isAffectedByDaylightSavingsTime) && !is_string($isAffectedByDaylightSavingsTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isAffectedByDaylightSavingsTime)), __LINE__);
        }
        $this->IsAffectedByDaylightSavingsTime = $isAffectedByDaylightSavingsTime;
        return $this;
    }
    /**
     * Get Holidays value
     * @return \StructType\Holidays
     */
    public function getHolidays()
    {
        return $this->Holidays;
    }
    /**
     * Set Holidays value
     * @param \StructType\Holidays $holidays
     * @return \StructType\StoreSchedule
     */
    public function setHolidays(\StructType\Holidays $holidays = null)
    {
        $this->Holidays = $holidays;
        return $this;
    }
    /**
     * Get HoursOfOperation value
     * @return \StructType\HoursOfOperation
     */
    public function getHoursOfOperation()
    {
        return $this->HoursOfOperation;
    }
    /**
     * Set HoursOfOperation value
     * @param \StructType\HoursOfOperation $hoursOfOperation
     * @return \StructType\StoreSchedule
     */
    public function setHoursOfOperation(\StructType\HoursOfOperation $hoursOfOperation = null)
    {
        $this->HoursOfOperation = $hoursOfOperation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoreSchedule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
