<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoreProducts StructType
 * @subpackage Structs
 */
class StoreProducts extends AbstractStructBase
{
    /**
     * The StoreID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StoreID;
    /**
     * The Products
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Products;
    /**
     * Constructor method for StoreProducts
     * @uses StoreProducts::setStoreID()
     * @uses StoreProducts::setProducts()
     * @param string $storeID
     * @param string $products
     */
    public function __construct($storeID = null, $products = null)
    {
        $this
            ->setStoreID($storeID)
            ->setProducts($products);
    }
    /**
     * Get StoreID value
     * @return string
     */
    public function getStoreID()
    {
        return $this->StoreID;
    }
    /**
     * Set StoreID value
     * @param string $storeID
     * @return \StructType\StoreProducts
     */
    public function setStoreID($storeID = null)
    {
        // validation for constraint: string
        if (!is_null($storeID) && !is_string($storeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($storeID)), __LINE__);
        }
        $this->StoreID = $storeID;
        return $this;
    }
    /**
     * Get Products value
     * @return string
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param string $products
     * @return \StructType\StoreProducts
     */
    public function setProducts($products = null)
    {
        // validation for constraint: string
        if (!is_null($products) && !is_string($products)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($products)), __LINE__);
        }
        $this->Products = $products;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoreProducts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
