<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoreInformation StructType
 * @subpackage Structs
 */
class StoreInformation extends AbstractStructBase
{
    /**
     * The StoreID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StoreID;
    /**
     * The BusinessDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BusinessDate;
    /**
     * The CurrentStoreTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CurrentStoreTime;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Version;
    /**
     * The PulseVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PulseVersion;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Phone;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The PreferredLanguage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PreferredLanguage;
    /**
     * The PreferredCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PreferredCurrency;
    /**
     * The DeliveryFeeTaxable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryFeeTaxable;
    /**
     * The MinimumDeliveryOrderAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MinimumDeliveryOrderAmount;
    /**
     * The RPAPIIgnoreMinDeliveryAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RPAPIIgnoreMinDeliveryAmount;
    /**
     * The RPAPIIgnoreOutOfDeliveryArea
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RPAPIIgnoreOutOfDeliveryArea;
    /**
     * The StoreSchedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\StoreSchedule
     */
    public $StoreSchedule;
    /**
     * The AcceptablePaymentTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AcceptablePaymentTypes
     */
    public $AcceptablePaymentTypes;
    /**
     * The StoreService
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\StoreService
     */
    public $StoreService;
    /**
     * The CancelOrderReasons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CancelOrderReasons
     */
    public $CancelOrderReasons;
    /**
     * The TaxStructure
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TaxStructure
     */
    public $TaxStructure;
    /**
     * The AcceptableCardTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AcceptableCardTypes
     */
    public $AcceptableCardTypes;
    /**
     * The OtherCardSettings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OtherCardSettings
     */
    public $OtherCardSettings;
    /**
     * The StoreServiceMethods
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StoreServiceMethods
     */
    public $StoreServiceMethods;
    /**
     * The Languages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Languages
     */
    public $Languages;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Longitude;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Latitude;
    /**
     * Constructor method for StoreInformation
     * @uses StoreInformation::setStoreID()
     * @uses StoreInformation::setBusinessDate()
     * @uses StoreInformation::setCurrentStoreTime()
     * @uses StoreInformation::setVersion()
     * @uses StoreInformation::setPulseVersion()
     * @uses StoreInformation::setPhone()
     * @uses StoreInformation::setAddress()
     * @uses StoreInformation::setPreferredLanguage()
     * @uses StoreInformation::setPreferredCurrency()
     * @uses StoreInformation::setDeliveryFeeTaxable()
     * @uses StoreInformation::setMinimumDeliveryOrderAmount()
     * @uses StoreInformation::setRPAPIIgnoreMinDeliveryAmount()
     * @uses StoreInformation::setRPAPIIgnoreOutOfDeliveryArea()
     * @uses StoreInformation::setStoreSchedule()
     * @uses StoreInformation::setAcceptablePaymentTypes()
     * @uses StoreInformation::setStoreService()
     * @uses StoreInformation::setCancelOrderReasons()
     * @uses StoreInformation::setTaxStructure()
     * @uses StoreInformation::setAcceptableCardTypes()
     * @uses StoreInformation::setOtherCardSettings()
     * @uses StoreInformation::setStoreServiceMethods()
     * @uses StoreInformation::setLanguages()
     * @uses StoreInformation::setLongitude()
     * @uses StoreInformation::setLatitude()
     * @param string $storeID
     * @param string $businessDate
     * @param string $currentStoreTime
     * @param string $version
     * @param string $pulseVersion
     * @param string $phone
     * @param \StructType\Address $address
     * @param string $preferredLanguage
     * @param string $preferredCurrency
     * @param string $deliveryFeeTaxable
     * @param string $minimumDeliveryOrderAmount
     * @param string $rPAPIIgnoreMinDeliveryAmount
     * @param string $rPAPIIgnoreOutOfDeliveryArea
     * @param \StructType\StoreSchedule $storeSchedule
     * @param \StructType\AcceptablePaymentTypes $acceptablePaymentTypes
     * @param \StructType\StoreService $storeService
     * @param \StructType\CancelOrderReasons $cancelOrderReasons
     * @param \StructType\TaxStructure $taxStructure
     * @param \StructType\AcceptableCardTypes $acceptableCardTypes
     * @param \StructType\OtherCardSettings $otherCardSettings
     * @param \StructType\StoreServiceMethods $storeServiceMethods
     * @param \StructType\Languages $languages
     * @param string $longitude
     * @param string $latitude
     */
    public function __construct($storeID = null, $businessDate = null, $currentStoreTime = null, $version = null, $pulseVersion = null, $phone = null, \StructType\Address $address = null, $preferredLanguage = null, $preferredCurrency = null, $deliveryFeeTaxable = null, $minimumDeliveryOrderAmount = null, $rPAPIIgnoreMinDeliveryAmount = null, $rPAPIIgnoreOutOfDeliveryArea = null, \StructType\StoreSchedule $storeSchedule = null, \StructType\AcceptablePaymentTypes $acceptablePaymentTypes = null, \StructType\StoreService $storeService = null, \StructType\CancelOrderReasons $cancelOrderReasons = null, \StructType\TaxStructure $taxStructure = null, \StructType\AcceptableCardTypes $acceptableCardTypes = null, \StructType\OtherCardSettings $otherCardSettings = null, \StructType\StoreServiceMethods $storeServiceMethods = null, \StructType\Languages $languages = null, $longitude = null, $latitude = null)
    {
        $this
            ->setStoreID($storeID)
            ->setBusinessDate($businessDate)
            ->setCurrentStoreTime($currentStoreTime)
            ->setVersion($version)
            ->setPulseVersion($pulseVersion)
            ->setPhone($phone)
            ->setAddress($address)
            ->setPreferredLanguage($preferredLanguage)
            ->setPreferredCurrency($preferredCurrency)
            ->setDeliveryFeeTaxable($deliveryFeeTaxable)
            ->setMinimumDeliveryOrderAmount($minimumDeliveryOrderAmount)
            ->setRPAPIIgnoreMinDeliveryAmount($rPAPIIgnoreMinDeliveryAmount)
            ->setRPAPIIgnoreOutOfDeliveryArea($rPAPIIgnoreOutOfDeliveryArea)
            ->setStoreSchedule($storeSchedule)
            ->setAcceptablePaymentTypes($acceptablePaymentTypes)
            ->setStoreService($storeService)
            ->setCancelOrderReasons($cancelOrderReasons)
            ->setTaxStructure($taxStructure)
            ->setAcceptableCardTypes($acceptableCardTypes)
            ->setOtherCardSettings($otherCardSettings)
            ->setStoreServiceMethods($storeServiceMethods)
            ->setLanguages($languages)
            ->setLongitude($longitude)
            ->setLatitude($latitude);
    }
    /**
     * Get StoreID value
     * @return string
     */
    public function getStoreID()
    {
        return $this->StoreID;
    }
    /**
     * Set StoreID value
     * @param string $storeID
     * @return \StructType\StoreInformation
     */
    public function setStoreID($storeID = null)
    {
        // validation for constraint: string
        if (!is_null($storeID) && !is_string($storeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($storeID)), __LINE__);
        }
        $this->StoreID = $storeID;
        return $this;
    }
    /**
     * Get BusinessDate value
     * @return string
     */
    public function getBusinessDate()
    {
        return $this->BusinessDate;
    }
    /**
     * Set BusinessDate value
     * @param string $businessDate
     * @return \StructType\StoreInformation
     */
    public function setBusinessDate($businessDate = null)
    {
        // validation for constraint: string
        if (!is_null($businessDate) && !is_string($businessDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($businessDate)), __LINE__);
        }
        $this->BusinessDate = $businessDate;
        return $this;
    }
    /**
     * Get CurrentStoreTime value
     * @return string
     */
    public function getCurrentStoreTime()
    {
        return $this->CurrentStoreTime;
    }
    /**
     * Set CurrentStoreTime value
     * @param string $currentStoreTime
     * @return \StructType\StoreInformation
     */
    public function setCurrentStoreTime($currentStoreTime = null)
    {
        // validation for constraint: string
        if (!is_null($currentStoreTime) && !is_string($currentStoreTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentStoreTime)), __LINE__);
        }
        $this->CurrentStoreTime = $currentStoreTime;
        return $this;
    }
    /**
     * Get Version value
     * @return string
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\StoreInformation
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get PulseVersion value
     * @return string
     */
    public function getPulseVersion()
    {
        return $this->PulseVersion;
    }
    /**
     * Set PulseVersion value
     * @param string $pulseVersion
     * @return \StructType\StoreInformation
     */
    public function setPulseVersion($pulseVersion = null)
    {
        // validation for constraint: string
        if (!is_null($pulseVersion) && !is_string($pulseVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pulseVersion)), __LINE__);
        }
        $this->PulseVersion = $pulseVersion;
        return $this;
    }
    /**
     * Get Phone value
     * @return string
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\StoreInformation
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\StoreInformation
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get PreferredLanguage value
     * @return string
     */
    public function getPreferredLanguage()
    {
        return $this->PreferredLanguage;
    }
    /**
     * Set PreferredLanguage value
     * @param string $preferredLanguage
     * @return \StructType\StoreInformation
     */
    public function setPreferredLanguage($preferredLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($preferredLanguage) && !is_string($preferredLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preferredLanguage)), __LINE__);
        }
        $this->PreferredLanguage = $preferredLanguage;
        return $this;
    }
    /**
     * Get PreferredCurrency value
     * @return string
     */
    public function getPreferredCurrency()
    {
        return $this->PreferredCurrency;
    }
    /**
     * Set PreferredCurrency value
     * @param string $preferredCurrency
     * @return \StructType\StoreInformation
     */
    public function setPreferredCurrency($preferredCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($preferredCurrency) && !is_string($preferredCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preferredCurrency)), __LINE__);
        }
        $this->PreferredCurrency = $preferredCurrency;
        return $this;
    }
    /**
     * Get DeliveryFeeTaxable value
     * @return string
     */
    public function getDeliveryFeeTaxable()
    {
        return $this->DeliveryFeeTaxable;
    }
    /**
     * Set DeliveryFeeTaxable value
     * @param string $deliveryFeeTaxable
     * @return \StructType\StoreInformation
     */
    public function setDeliveryFeeTaxable($deliveryFeeTaxable = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryFeeTaxable) && !is_string($deliveryFeeTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryFeeTaxable)), __LINE__);
        }
        $this->DeliveryFeeTaxable = $deliveryFeeTaxable;
        return $this;
    }
    /**
     * Get MinimumDeliveryOrderAmount value
     * @return string
     */
    public function getMinimumDeliveryOrderAmount()
    {
        return $this->MinimumDeliveryOrderAmount;
    }
    /**
     * Set MinimumDeliveryOrderAmount value
     * @param string $minimumDeliveryOrderAmount
     * @return \StructType\StoreInformation
     */
    public function setMinimumDeliveryOrderAmount($minimumDeliveryOrderAmount = null)
    {
        // validation for constraint: string
        if (!is_null($minimumDeliveryOrderAmount) && !is_string($minimumDeliveryOrderAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minimumDeliveryOrderAmount)), __LINE__);
        }
        $this->MinimumDeliveryOrderAmount = $minimumDeliveryOrderAmount;
        return $this;
    }
    /**
     * Get RPAPIIgnoreMinDeliveryAmount value
     * @return string
     */
    public function getRPAPIIgnoreMinDeliveryAmount()
    {
        return $this->RPAPIIgnoreMinDeliveryAmount;
    }
    /**
     * Set RPAPIIgnoreMinDeliveryAmount value
     * @param string $rPAPIIgnoreMinDeliveryAmount
     * @return \StructType\StoreInformation
     */
    public function setRPAPIIgnoreMinDeliveryAmount($rPAPIIgnoreMinDeliveryAmount = null)
    {
        // validation for constraint: string
        if (!is_null($rPAPIIgnoreMinDeliveryAmount) && !is_string($rPAPIIgnoreMinDeliveryAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPAPIIgnoreMinDeliveryAmount)), __LINE__);
        }
        $this->RPAPIIgnoreMinDeliveryAmount = $rPAPIIgnoreMinDeliveryAmount;
        return $this;
    }
    /**
     * Get RPAPIIgnoreOutOfDeliveryArea value
     * @return string
     */
    public function getRPAPIIgnoreOutOfDeliveryArea()
    {
        return $this->RPAPIIgnoreOutOfDeliveryArea;
    }
    /**
     * Set RPAPIIgnoreOutOfDeliveryArea value
     * @param string $rPAPIIgnoreOutOfDeliveryArea
     * @return \StructType\StoreInformation
     */
    public function setRPAPIIgnoreOutOfDeliveryArea($rPAPIIgnoreOutOfDeliveryArea = null)
    {
        // validation for constraint: string
        if (!is_null($rPAPIIgnoreOutOfDeliveryArea) && !is_string($rPAPIIgnoreOutOfDeliveryArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPAPIIgnoreOutOfDeliveryArea)), __LINE__);
        }
        $this->RPAPIIgnoreOutOfDeliveryArea = $rPAPIIgnoreOutOfDeliveryArea;
        return $this;
    }
    /**
     * Get StoreSchedule value
     * @return \StructType\StoreSchedule
     */
    public function getStoreSchedule()
    {
        return $this->StoreSchedule;
    }
    /**
     * Set StoreSchedule value
     * @param \StructType\StoreSchedule $storeSchedule
     * @return \StructType\StoreInformation
     */
    public function setStoreSchedule(\StructType\StoreSchedule $storeSchedule = null)
    {
        $this->StoreSchedule = $storeSchedule;
        return $this;
    }
    /**
     * Get AcceptablePaymentTypes value
     * @return \StructType\AcceptablePaymentTypes
     */
    public function getAcceptablePaymentTypes()
    {
        return $this->AcceptablePaymentTypes;
    }
    /**
     * Set AcceptablePaymentTypes value
     * @param \StructType\AcceptablePaymentTypes $acceptablePaymentTypes
     * @return \StructType\StoreInformation
     */
    public function setAcceptablePaymentTypes(\StructType\AcceptablePaymentTypes $acceptablePaymentTypes = null)
    {
        $this->AcceptablePaymentTypes = $acceptablePaymentTypes;
        return $this;
    }
    /**
     * Get StoreService value
     * @return \StructType\StoreService
     */
    public function getStoreService()
    {
        return $this->StoreService;
    }
    /**
     * Set StoreService value
     * @param \StructType\StoreService $storeService
     * @return \StructType\StoreInformation
     */
    public function setStoreService(\StructType\StoreService $storeService = null)
    {
        $this->StoreService = $storeService;
        return $this;
    }
    /**
     * Get CancelOrderReasons value
     * @return \StructType\CancelOrderReasons
     */
    public function getCancelOrderReasons()
    {
        return $this->CancelOrderReasons;
    }
    /**
     * Set CancelOrderReasons value
     * @param \StructType\CancelOrderReasons $cancelOrderReasons
     * @return \StructType\StoreInformation
     */
    public function setCancelOrderReasons(\StructType\CancelOrderReasons $cancelOrderReasons = null)
    {
        $this->CancelOrderReasons = $cancelOrderReasons;
        return $this;
    }
    /**
     * Get TaxStructure value
     * @return \StructType\TaxStructure
     */
    public function getTaxStructure()
    {
        return $this->TaxStructure;
    }
    /**
     * Set TaxStructure value
     * @param \StructType\TaxStructure $taxStructure
     * @return \StructType\StoreInformation
     */
    public function setTaxStructure(\StructType\TaxStructure $taxStructure = null)
    {
        $this->TaxStructure = $taxStructure;
        return $this;
    }
    /**
     * Get AcceptableCardTypes value
     * @return \StructType\AcceptableCardTypes
     */
    public function getAcceptableCardTypes()
    {
        return $this->AcceptableCardTypes;
    }
    /**
     * Set AcceptableCardTypes value
     * @param \StructType\AcceptableCardTypes $acceptableCardTypes
     * @return \StructType\StoreInformation
     */
    public function setAcceptableCardTypes(\StructType\AcceptableCardTypes $acceptableCardTypes = null)
    {
        $this->AcceptableCardTypes = $acceptableCardTypes;
        return $this;
    }
    /**
     * Get OtherCardSettings value
     * @return \StructType\OtherCardSettings
     */
    public function getOtherCardSettings()
    {
        return $this->OtherCardSettings;
    }
    /**
     * Set OtherCardSettings value
     * @param \StructType\OtherCardSettings $otherCardSettings
     * @return \StructType\StoreInformation
     */
    public function setOtherCardSettings(\StructType\OtherCardSettings $otherCardSettings = null)
    {
        $this->OtherCardSettings = $otherCardSettings;
        return $this;
    }
    /**
     * Get StoreServiceMethods value
     * @return \StructType\StoreServiceMethods|null
     */
    public function getStoreServiceMethods()
    {
        return $this->StoreServiceMethods;
    }
    /**
     * Set StoreServiceMethods value
     * @param \StructType\StoreServiceMethods $storeServiceMethods
     * @return \StructType\StoreInformation
     */
    public function setStoreServiceMethods(\StructType\StoreServiceMethods $storeServiceMethods = null)
    {
        $this->StoreServiceMethods = $storeServiceMethods;
        return $this;
    }
    /**
     * Get Languages value
     * @return \StructType\Languages|null
     */
    public function getLanguages()
    {
        return $this->Languages;
    }
    /**
     * Set Languages value
     * @param \StructType\Languages $languages
     * @return \StructType\StoreInformation
     */
    public function setLanguages(\StructType\Languages $languages = null)
    {
        $this->Languages = $languages;
        return $this;
    }
    /**
     * Get Longitude value
     * @return string|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param string $longitude
     * @return \StructType\StoreInformation
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: string
        if (!is_null($longitude) && !is_string($longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Latitude value
     * @return string|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param string $latitude
     * @return \StructType\StoreInformation
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: string
        if (!is_null($latitude) && !is_string($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoreInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
