<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusReply StructType
 * @subpackage Structs
 */
class StatusReply extends AbstractStructBase
{
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The StatusText
     * @var string
     */
    public $StatusText;
    /**
     * Constructor method for StatusReply
     * @uses StatusReply::setStatus()
     * @uses StatusReply::setStatusText()
     * @param string $status
     * @param string $statusText
     */
    public function __construct($status = null, $statusText = null)
    {
        $this
            ->setStatus($status)
            ->setStatusText($statusText);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\StatusReply
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusText value
     * @return string|null
     */
    public function getStatusText()
    {
        return $this->StatusText;
    }
    /**
     * Set StatusText value
     * @param string $statusText
     * @return \StructType\StatusReply
     */
    public function setStatusText($statusText = null)
    {
        // validation for constraint: string
        if (!is_null($statusText) && !is_string($statusText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusText)), __LINE__);
        }
        $this->StatusText = $statusText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StatusReply
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
