<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Source StructType
 * @subpackage Structs
 */
class Source extends AbstractStructBase
{
    /**
     * The SourceCode
     * @var string
     */
    public $SourceCode;
    /**
     * Constructor method for Source
     * @uses Source::setSourceCode()
     * @param string $sourceCode
     */
    public function __construct($sourceCode = null)
    {
        $this
            ->setSourceCode($sourceCode);
    }
    /**
     * Get SourceCode value
     * @return string|null
     */
    public function getSourceCode()
    {
        return $this->SourceCode;
    }
    /**
     * Set SourceCode value
     * @param string $sourceCode
     * @return \StructType\Source
     */
    public function setSourceCode($sourceCode = null)
    {
        // validation for constraint: string
        if (!is_null($sourceCode) && !is_string($sourceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceCode)), __LINE__);
        }
        $this->SourceCode = $sourceCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Source
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
