<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductCodes StructType
 * @subpackage Structs
 */
class ProductCodes extends AbstractStructBase
{
    /**
     * The ProductCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 1
     * @var \StructType\ProductCode[]
     */
    public $ProductCode;
    /**
     * Constructor method for ProductCodes
     * @uses ProductCodes::setProductCode()
     * @param \StructType\ProductCode[] $productCode
     */
    public function __construct(array $productCode = array())
    {
        $this
            ->setProductCode($productCode);
    }
    /**
     * Get ProductCode value
     * @return \StructType\ProductCode[]
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductCode[] $productCode
     * @return \StructType\ProductCodes
     */
    public function setProductCode(array $productCode = array())
    {
        foreach ($productCode as $productCodesProductCodeItem) {
            // validation for constraint: itemType
            if (!$productCodesProductCodeItem instanceof \StructType\ProductCode) {
                throw new \InvalidArgumentException(sprintf('The ProductCode property can only contain items of \StructType\ProductCode, "%s" given', is_object($productCodesProductCodeItem) ? get_class($productCodesProductCodeItem) : gettype($productCodesProductCodeItem)), __LINE__);
            }
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Add item to ProductCode value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductCode $item
     * @return \StructType\ProductCodes
     */
    public function addToProductCode(\StructType\ProductCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductCode) {
            throw new \InvalidArgumentException(sprintf('The ProductCode property can only contain items of \StructType\ProductCode, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
