<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PointsPayment StructType
 * @subpackage Structs
 */
class PointsPayment extends AbstractStructBase
{
    /**
     * The PaymentSubTypeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentSubTypeId;
    /**
     * The PaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentAmount;
    /**
     * Constructor method for PointsPayment
     * @uses PointsPayment::setPaymentSubTypeId()
     * @uses PointsPayment::setPaymentAmount()
     * @param string $paymentSubTypeId
     * @param string $paymentAmount
     */
    public function __construct($paymentSubTypeId = null, $paymentAmount = null)
    {
        $this
            ->setPaymentSubTypeId($paymentSubTypeId)
            ->setPaymentAmount($paymentAmount);
    }
    /**
     * Get PaymentSubTypeId value
     * @return string
     */
    public function getPaymentSubTypeId()
    {
        return $this->PaymentSubTypeId;
    }
    /**
     * Set PaymentSubTypeId value
     * @param string $paymentSubTypeId
     * @return \StructType\PointsPayment
     */
    public function setPaymentSubTypeId($paymentSubTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSubTypeId) && !is_string($paymentSubTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentSubTypeId)), __LINE__);
        }
        $this->PaymentSubTypeId = $paymentSubTypeId;
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return string|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param string $paymentAmount
     * @return \StructType\PointsPayment
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: string
        if (!is_null($paymentAmount) && !is_string($paymentAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentAmount)), __LINE__);
        }
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PointsPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
