<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderTimings StructType
 * @subpackage Structs
 */
class OrderTimings extends AbstractStructBase
{
    /**
     * The AsOfTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AsOfTime;
    /**
     * The StartTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartTime;
    /**
     * The OrderTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderTime;
    /**
     * The SystemEnteredTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemEnteredTime;
    /**
     * The DispatchTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DispatchTime;
    /**
     * The ServiceTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceTime;
    /**
     * The CompletedTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompletedTime;
    /**
     * The QuotedStartTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QuotedStartTime;
    /**
     * The EstimatedStartTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EstimatedStartTime;
    /**
     * The QuotedServiceTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QuotedServiceTime;
    /**
     * The EstimatedServiceTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EstimatedServiceTime;
    /**
     * The EstimatedServiceTimeMinimum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EstimatedServiceTimeMinimum;
    /**
     * The EstimatedServiceTimeMaximum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EstimatedServiceTimeMaximum;
    /**
     * The FirstContactTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstContactTime;
    /**
     * Constructor method for OrderTimings
     * @uses OrderTimings::setAsOfTime()
     * @uses OrderTimings::setStartTime()
     * @uses OrderTimings::setOrderTime()
     * @uses OrderTimings::setSystemEnteredTime()
     * @uses OrderTimings::setDispatchTime()
     * @uses OrderTimings::setServiceTime()
     * @uses OrderTimings::setCompletedTime()
     * @uses OrderTimings::setQuotedStartTime()
     * @uses OrderTimings::setEstimatedStartTime()
     * @uses OrderTimings::setQuotedServiceTime()
     * @uses OrderTimings::setEstimatedServiceTime()
     * @uses OrderTimings::setEstimatedServiceTimeMinimum()
     * @uses OrderTimings::setEstimatedServiceTimeMaximum()
     * @uses OrderTimings::setFirstContactTime()
     * @param string $asOfTime
     * @param string $startTime
     * @param string $orderTime
     * @param string $systemEnteredTime
     * @param string $dispatchTime
     * @param string $serviceTime
     * @param string $completedTime
     * @param string $quotedStartTime
     * @param string $estimatedStartTime
     * @param string $quotedServiceTime
     * @param string $estimatedServiceTime
     * @param string $estimatedServiceTimeMinimum
     * @param string $estimatedServiceTimeMaximum
     * @param string $firstContactTime
     */
    public function __construct($asOfTime = null, $startTime = null, $orderTime = null, $systemEnteredTime = null, $dispatchTime = null, $serviceTime = null, $completedTime = null, $quotedStartTime = null, $estimatedStartTime = null, $quotedServiceTime = null, $estimatedServiceTime = null, $estimatedServiceTimeMinimum = null, $estimatedServiceTimeMaximum = null, $firstContactTime = null)
    {
        $this
            ->setAsOfTime($asOfTime)
            ->setStartTime($startTime)
            ->setOrderTime($orderTime)
            ->setSystemEnteredTime($systemEnteredTime)
            ->setDispatchTime($dispatchTime)
            ->setServiceTime($serviceTime)
            ->setCompletedTime($completedTime)
            ->setQuotedStartTime($quotedStartTime)
            ->setEstimatedStartTime($estimatedStartTime)
            ->setQuotedServiceTime($quotedServiceTime)
            ->setEstimatedServiceTime($estimatedServiceTime)
            ->setEstimatedServiceTimeMinimum($estimatedServiceTimeMinimum)
            ->setEstimatedServiceTimeMaximum($estimatedServiceTimeMaximum)
            ->setFirstContactTime($firstContactTime);
    }
    /**
     * Get AsOfTime value
     * @return string|null
     */
    public function getAsOfTime()
    {
        return $this->AsOfTime;
    }
    /**
     * Set AsOfTime value
     * @param string $asOfTime
     * @return \StructType\OrderTimings
     */
    public function setAsOfTime($asOfTime = null)
    {
        // validation for constraint: string
        if (!is_null($asOfTime) && !is_string($asOfTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asOfTime)), __LINE__);
        }
        $this->AsOfTime = $asOfTime;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\OrderTimings
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get OrderTime value
     * @return string|null
     */
    public function getOrderTime()
    {
        return $this->OrderTime;
    }
    /**
     * Set OrderTime value
     * @param string $orderTime
     * @return \StructType\OrderTimings
     */
    public function setOrderTime($orderTime = null)
    {
        // validation for constraint: string
        if (!is_null($orderTime) && !is_string($orderTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderTime)), __LINE__);
        }
        $this->OrderTime = $orderTime;
        return $this;
    }
    /**
     * Get SystemEnteredTime value
     * @return string|null
     */
    public function getSystemEnteredTime()
    {
        return $this->SystemEnteredTime;
    }
    /**
     * Set SystemEnteredTime value
     * @param string $systemEnteredTime
     * @return \StructType\OrderTimings
     */
    public function setSystemEnteredTime($systemEnteredTime = null)
    {
        // validation for constraint: string
        if (!is_null($systemEnteredTime) && !is_string($systemEnteredTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemEnteredTime)), __LINE__);
        }
        $this->SystemEnteredTime = $systemEnteredTime;
        return $this;
    }
    /**
     * Get DispatchTime value
     * @return string|null
     */
    public function getDispatchTime()
    {
        return $this->DispatchTime;
    }
    /**
     * Set DispatchTime value
     * @param string $dispatchTime
     * @return \StructType\OrderTimings
     */
    public function setDispatchTime($dispatchTime = null)
    {
        // validation for constraint: string
        if (!is_null($dispatchTime) && !is_string($dispatchTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dispatchTime)), __LINE__);
        }
        $this->DispatchTime = $dispatchTime;
        return $this;
    }
    /**
     * Get ServiceTime value
     * @return string|null
     */
    public function getServiceTime()
    {
        return $this->ServiceTime;
    }
    /**
     * Set ServiceTime value
     * @param string $serviceTime
     * @return \StructType\OrderTimings
     */
    public function setServiceTime($serviceTime = null)
    {
        // validation for constraint: string
        if (!is_null($serviceTime) && !is_string($serviceTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceTime)), __LINE__);
        }
        $this->ServiceTime = $serviceTime;
        return $this;
    }
    /**
     * Get CompletedTime value
     * @return string|null
     */
    public function getCompletedTime()
    {
        return $this->CompletedTime;
    }
    /**
     * Set CompletedTime value
     * @param string $completedTime
     * @return \StructType\OrderTimings
     */
    public function setCompletedTime($completedTime = null)
    {
        // validation for constraint: string
        if (!is_null($completedTime) && !is_string($completedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($completedTime)), __LINE__);
        }
        $this->CompletedTime = $completedTime;
        return $this;
    }
    /**
     * Get QuotedStartTime value
     * @return string|null
     */
    public function getQuotedStartTime()
    {
        return $this->QuotedStartTime;
    }
    /**
     * Set QuotedStartTime value
     * @param string $quotedStartTime
     * @return \StructType\OrderTimings
     */
    public function setQuotedStartTime($quotedStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($quotedStartTime) && !is_string($quotedStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quotedStartTime)), __LINE__);
        }
        $this->QuotedStartTime = $quotedStartTime;
        return $this;
    }
    /**
     * Get EstimatedStartTime value
     * @return string|null
     */
    public function getEstimatedStartTime()
    {
        return $this->EstimatedStartTime;
    }
    /**
     * Set EstimatedStartTime value
     * @param string $estimatedStartTime
     * @return \StructType\OrderTimings
     */
    public function setEstimatedStartTime($estimatedStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedStartTime) && !is_string($estimatedStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedStartTime)), __LINE__);
        }
        $this->EstimatedStartTime = $estimatedStartTime;
        return $this;
    }
    /**
     * Get QuotedServiceTime value
     * @return string|null
     */
    public function getQuotedServiceTime()
    {
        return $this->QuotedServiceTime;
    }
    /**
     * Set QuotedServiceTime value
     * @param string $quotedServiceTime
     * @return \StructType\OrderTimings
     */
    public function setQuotedServiceTime($quotedServiceTime = null)
    {
        // validation for constraint: string
        if (!is_null($quotedServiceTime) && !is_string($quotedServiceTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quotedServiceTime)), __LINE__);
        }
        $this->QuotedServiceTime = $quotedServiceTime;
        return $this;
    }
    /**
     * Get EstimatedServiceTime value
     * @return string|null
     */
    public function getEstimatedServiceTime()
    {
        return $this->EstimatedServiceTime;
    }
    /**
     * Set EstimatedServiceTime value
     * @param string $estimatedServiceTime
     * @return \StructType\OrderTimings
     */
    public function setEstimatedServiceTime($estimatedServiceTime = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedServiceTime) && !is_string($estimatedServiceTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedServiceTime)), __LINE__);
        }
        $this->EstimatedServiceTime = $estimatedServiceTime;
        return $this;
    }
    /**
     * Get EstimatedServiceTimeMinimum value
     * @return string|null
     */
    public function getEstimatedServiceTimeMinimum()
    {
        return $this->EstimatedServiceTimeMinimum;
    }
    /**
     * Set EstimatedServiceTimeMinimum value
     * @param string $estimatedServiceTimeMinimum
     * @return \StructType\OrderTimings
     */
    public function setEstimatedServiceTimeMinimum($estimatedServiceTimeMinimum = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedServiceTimeMinimum) && !is_string($estimatedServiceTimeMinimum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedServiceTimeMinimum)), __LINE__);
        }
        $this->EstimatedServiceTimeMinimum = $estimatedServiceTimeMinimum;
        return $this;
    }
    /**
     * Get EstimatedServiceTimeMaximum value
     * @return string|null
     */
    public function getEstimatedServiceTimeMaximum()
    {
        return $this->EstimatedServiceTimeMaximum;
    }
    /**
     * Set EstimatedServiceTimeMaximum value
     * @param string $estimatedServiceTimeMaximum
     * @return \StructType\OrderTimings
     */
    public function setEstimatedServiceTimeMaximum($estimatedServiceTimeMaximum = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedServiceTimeMaximum) && !is_string($estimatedServiceTimeMaximum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedServiceTimeMaximum)), __LINE__);
        }
        $this->EstimatedServiceTimeMaximum = $estimatedServiceTimeMaximum;
        return $this;
    }
    /**
     * Get FirstContactTime value
     * @return string|null
     */
    public function getFirstContactTime()
    {
        return $this->FirstContactTime;
    }
    /**
     * Set FirstContactTime value
     * @param string $firstContactTime
     * @return \StructType\OrderTimings
     */
    public function setFirstContactTime($firstContactTime = null)
    {
        // validation for constraint: string
        if (!is_null($firstContactTime) && !is_string($firstContactTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstContactTime)), __LINE__);
        }
        $this->FirstContactTime = $firstContactTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderTimings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
