<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderStatuses StructType
 * @subpackage Structs
 */
class OrderStatuses extends AbstractStructBase
{
    /**
     * The OrderReply
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrderItem[]
     */
    public $OrderReply;
    /**
     * Constructor method for OrderStatuses
     * @uses OrderStatuses::setOrderReply()
     * @param \StructType\OrderItem[] $orderReply
     */
    public function __construct(array $orderReply = array())
    {
        $this
            ->setOrderReply($orderReply);
    }
    /**
     * Get OrderReply value
     * @return \StructType\OrderItem[]|null
     */
    public function getOrderReply()
    {
        return $this->OrderReply;
    }
    /**
     * Set OrderReply value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItem[] $orderReply
     * @return \StructType\OrderStatuses
     */
    public function setOrderReply(array $orderReply = array())
    {
        foreach ($orderReply as $orderStatusesOrderReplyItem) {
            // validation for constraint: itemType
            if (!$orderStatusesOrderReplyItem instanceof \StructType\OrderItem) {
                throw new \InvalidArgumentException(sprintf('The OrderReply property can only contain items of \StructType\OrderItem, "%s" given', is_object($orderStatusesOrderReplyItem) ? get_class($orderStatusesOrderReplyItem) : gettype($orderStatusesOrderReplyItem)), __LINE__);
            }
        }
        $this->OrderReply = $orderReply;
        return $this;
    }
    /**
     * Add item to OrderReply value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItem $item
     * @return \StructType\OrderStatuses
     */
    public function addToOrderReply(\StructType\OrderItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderItem) {
            throw new \InvalidArgumentException(sprintf('The OrderReply property can only contain items of \StructType\OrderItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrderReply[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderStatuses
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
