<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderSource StructType
 * @subpackage Structs
 */
class OrderSource extends AbstractStructBase
{
    /**
     * The OrganizationURI
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrganizationURI;
    /**
     * The OrderMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderMethod;
    /**
     * The OrderTaker
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderTaker;
    /**
     * The EndUserIPAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EndUserIPAddress;
    /**
     * The PowerServerIPAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PowerServerIPAddress;
    /**
     * Constructor method for OrderSource
     * @uses OrderSource::setOrganizationURI()
     * @uses OrderSource::setOrderMethod()
     * @uses OrderSource::setOrderTaker()
     * @uses OrderSource::setEndUserIPAddress()
     * @uses OrderSource::setPowerServerIPAddress()
     * @param string $organizationURI
     * @param string $orderMethod
     * @param string $orderTaker
     * @param string $endUserIPAddress
     * @param string $powerServerIPAddress
     */
    public function __construct($organizationURI = null, $orderMethod = null, $orderTaker = null, $endUserIPAddress = null, $powerServerIPAddress = null)
    {
        $this
            ->setOrganizationURI($organizationURI)
            ->setOrderMethod($orderMethod)
            ->setOrderTaker($orderTaker)
            ->setEndUserIPAddress($endUserIPAddress)
            ->setPowerServerIPAddress($powerServerIPAddress);
    }
    /**
     * Get OrganizationURI value
     * @return string
     */
    public function getOrganizationURI()
    {
        return $this->OrganizationURI;
    }
    /**
     * Set OrganizationURI value
     * @param string $organizationURI
     * @return \StructType\OrderSource
     */
    public function setOrganizationURI($organizationURI = null)
    {
        // validation for constraint: string
        if (!is_null($organizationURI) && !is_string($organizationURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organizationURI)), __LINE__);
        }
        $this->OrganizationURI = $organizationURI;
        return $this;
    }
    /**
     * Get OrderMethod value
     * @return string
     */
    public function getOrderMethod()
    {
        return $this->OrderMethod;
    }
    /**
     * Set OrderMethod value
     * @param string $orderMethod
     * @return \StructType\OrderSource
     */
    public function setOrderMethod($orderMethod = null)
    {
        // validation for constraint: string
        if (!is_null($orderMethod) && !is_string($orderMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderMethod)), __LINE__);
        }
        $this->OrderMethod = $orderMethod;
        return $this;
    }
    /**
     * Get OrderTaker value
     * @return string
     */
    public function getOrderTaker()
    {
        return $this->OrderTaker;
    }
    /**
     * Set OrderTaker value
     * @param string $orderTaker
     * @return \StructType\OrderSource
     */
    public function setOrderTaker($orderTaker = null)
    {
        // validation for constraint: string
        if (!is_null($orderTaker) && !is_string($orderTaker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderTaker)), __LINE__);
        }
        $this->OrderTaker = $orderTaker;
        return $this;
    }
    /**
     * Get EndUserIPAddress value
     * @return string|null
     */
    public function getEndUserIPAddress()
    {
        return $this->EndUserIPAddress;
    }
    /**
     * Set EndUserIPAddress value
     * @param string $endUserIPAddress
     * @return \StructType\OrderSource
     */
    public function setEndUserIPAddress($endUserIPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($endUserIPAddress) && !is_string($endUserIPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endUserIPAddress)), __LINE__);
        }
        $this->EndUserIPAddress = $endUserIPAddress;
        return $this;
    }
    /**
     * Get PowerServerIPAddress value
     * @return string|null
     */
    public function getPowerServerIPAddress()
    {
        return $this->PowerServerIPAddress;
    }
    /**
     * Set PowerServerIPAddress value
     * @param string $powerServerIPAddress
     * @return \StructType\OrderSource
     */
    public function setPowerServerIPAddress($powerServerIPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($powerServerIPAddress) && !is_string($powerServerIPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($powerServerIPAddress)), __LINE__);
        }
        $this->PowerServerIPAddress = $powerServerIPAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderSource
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
