<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderReply StructType
 * @subpackage Structs
 */
class OrderReply extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The StatusText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StatusText;
    /**
     * The StoreID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StoreID;
    /**
     * The ServiceMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceMethod;
    /**
     * The BusinessDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BusinessDate;
    /**
     * The EstimatedWaitTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EstimatedWaitTime;
    /**
     * The OrderAmounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderAmounts
     */
    public $OrderAmounts;
    /**
     * The OrderTimings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderTimings
     */
    public $OrderTimings;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Message;
    /**
     * The OrderText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderText;
    /**
     * The Order
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Order
     */
    public $Order;
    /**
     * The CanPlaceOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CanPlaceOrder;
    /**
     * The StoreOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StoreOrderID;
    /**
     * The AdvanceOrderTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdvanceOrderTime;
    /**
     * The AdvanceOrderTimeLocal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdvanceOrderTimeLocal;
    /**
     * The TestOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TestOrder;
    /**
     * The TestDelayMS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TestDelayMS;
    /**
     * The PulseOrderGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PulseOrderGUID;
    /**
     * The OrderProgress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderProgress;
    /**
     * The IsExpedited
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsExpedited;
    /**
     * The orderreplyid
     * @var string
     */
    public $orderreplyid;
    /**
     * Constructor method for OrderReply
     * @uses OrderReply::setStatus()
     * @uses OrderReply::setStatusText()
     * @uses OrderReply::setStoreID()
     * @uses OrderReply::setServiceMethod()
     * @uses OrderReply::setBusinessDate()
     * @uses OrderReply::setEstimatedWaitTime()
     * @uses OrderReply::setOrderAmounts()
     * @uses OrderReply::setOrderTimings()
     * @uses OrderReply::setMessage()
     * @uses OrderReply::setOrderText()
     * @uses OrderReply::setOrder()
     * @uses OrderReply::setCanPlaceOrder()
     * @uses OrderReply::setStoreOrderID()
     * @uses OrderReply::setAdvanceOrderTime()
     * @uses OrderReply::setAdvanceOrderTimeLocal()
     * @uses OrderReply::setTestOrder()
     * @uses OrderReply::setTestDelayMS()
     * @uses OrderReply::setPulseOrderGUID()
     * @uses OrderReply::setOrderProgress()
     * @uses OrderReply::setIsExpedited()
     * @uses OrderReply::setOrderreplyid()
     * @param int $status
     * @param string $statusText
     * @param string $storeID
     * @param string $serviceMethod
     * @param string $businessDate
     * @param string $estimatedWaitTime
     * @param \StructType\OrderAmounts $orderAmounts
     * @param \StructType\OrderTimings $orderTimings
     * @param string $message
     * @param string $orderText
     * @param \StructType\Order $order
     * @param string $canPlaceOrder
     * @param string $storeOrderID
     * @param string $advanceOrderTime
     * @param string $advanceOrderTimeLocal
     * @param string $testOrder
     * @param string $testDelayMS
     * @param string $pulseOrderGUID
     * @param string $orderProgress
     * @param bool $isExpedited
     * @param string $orderreplyid
     */
    public function __construct($status = null, $statusText = null, $storeID = null, $serviceMethod = null, $businessDate = null, $estimatedWaitTime = null, \StructType\OrderAmounts $orderAmounts = null, \StructType\OrderTimings $orderTimings = null, $message = null, $orderText = null, \StructType\Order $order = null, $canPlaceOrder = null, $storeOrderID = null, $advanceOrderTime = null, $advanceOrderTimeLocal = null, $testOrder = null, $testDelayMS = null, $pulseOrderGUID = null, $orderProgress = null, $isExpedited = null, $orderreplyid = null)
    {
        $this
            ->setStatus($status)
            ->setStatusText($statusText)
            ->setStoreID($storeID)
            ->setServiceMethod($serviceMethod)
            ->setBusinessDate($businessDate)
            ->setEstimatedWaitTime($estimatedWaitTime)
            ->setOrderAmounts($orderAmounts)
            ->setOrderTimings($orderTimings)
            ->setMessage($message)
            ->setOrderText($orderText)
            ->setOrder($order)
            ->setCanPlaceOrder($canPlaceOrder)
            ->setStoreOrderID($storeOrderID)
            ->setAdvanceOrderTime($advanceOrderTime)
            ->setAdvanceOrderTimeLocal($advanceOrderTimeLocal)
            ->setTestOrder($testOrder)
            ->setTestDelayMS($testDelayMS)
            ->setPulseOrderGUID($pulseOrderGUID)
            ->setOrderProgress($orderProgress)
            ->setIsExpedited($isExpedited)
            ->setOrderreplyid($orderreplyid);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \StructType\OrderReply
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusText value
     * @return string
     */
    public function getStatusText()
    {
        return $this->StatusText;
    }
    /**
     * Set StatusText value
     * @param string $statusText
     * @return \StructType\OrderReply
     */
    public function setStatusText($statusText = null)
    {
        // validation for constraint: string
        if (!is_null($statusText) && !is_string($statusText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusText)), __LINE__);
        }
        $this->StatusText = $statusText;
        return $this;
    }
    /**
     * Get StoreID value
     * @return string
     */
    public function getStoreID()
    {
        return $this->StoreID;
    }
    /**
     * Set StoreID value
     * @param string $storeID
     * @return \StructType\OrderReply
     */
    public function setStoreID($storeID = null)
    {
        // validation for constraint: string
        if (!is_null($storeID) && !is_string($storeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($storeID)), __LINE__);
        }
        $this->StoreID = $storeID;
        return $this;
    }
    /**
     * Get ServiceMethod value
     * @return string
     */
    public function getServiceMethod()
    {
        return $this->ServiceMethod;
    }
    /**
     * Set ServiceMethod value
     * @param string $serviceMethod
     * @return \StructType\OrderReply
     */
    public function setServiceMethod($serviceMethod = null)
    {
        // validation for constraint: string
        if (!is_null($serviceMethod) && !is_string($serviceMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceMethod)), __LINE__);
        }
        $this->ServiceMethod = $serviceMethod;
        return $this;
    }
    /**
     * Get BusinessDate value
     * @return string
     */
    public function getBusinessDate()
    {
        return $this->BusinessDate;
    }
    /**
     * Set BusinessDate value
     * @param string $businessDate
     * @return \StructType\OrderReply
     */
    public function setBusinessDate($businessDate = null)
    {
        // validation for constraint: string
        if (!is_null($businessDate) && !is_string($businessDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($businessDate)), __LINE__);
        }
        $this->BusinessDate = $businessDate;
        return $this;
    }
    /**
     * Get EstimatedWaitTime value
     * @return string
     */
    public function getEstimatedWaitTime()
    {
        return $this->EstimatedWaitTime;
    }
    /**
     * Set EstimatedWaitTime value
     * @param string $estimatedWaitTime
     * @return \StructType\OrderReply
     */
    public function setEstimatedWaitTime($estimatedWaitTime = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedWaitTime) && !is_string($estimatedWaitTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedWaitTime)), __LINE__);
        }
        $this->EstimatedWaitTime = $estimatedWaitTime;
        return $this;
    }
    /**
     * Get OrderAmounts value
     * @return \StructType\OrderAmounts
     */
    public function getOrderAmounts()
    {
        return $this->OrderAmounts;
    }
    /**
     * Set OrderAmounts value
     * @param \StructType\OrderAmounts $orderAmounts
     * @return \StructType\OrderReply
     */
    public function setOrderAmounts(\StructType\OrderAmounts $orderAmounts = null)
    {
        $this->OrderAmounts = $orderAmounts;
        return $this;
    }
    /**
     * Get OrderTimings value
     * @return \StructType\OrderTimings
     */
    public function getOrderTimings()
    {
        return $this->OrderTimings;
    }
    /**
     * Set OrderTimings value
     * @param \StructType\OrderTimings $orderTimings
     * @return \StructType\OrderReply
     */
    public function setOrderTimings(\StructType\OrderTimings $orderTimings = null)
    {
        $this->OrderTimings = $orderTimings;
        return $this;
    }
    /**
     * Get Message value
     * @return string
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\OrderReply
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get OrderText value
     * @return string
     */
    public function getOrderText()
    {
        return $this->OrderText;
    }
    /**
     * Set OrderText value
     * @param string $orderText
     * @return \StructType\OrderReply
     */
    public function setOrderText($orderText = null)
    {
        // validation for constraint: string
        if (!is_null($orderText) && !is_string($orderText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderText)), __LINE__);
        }
        $this->OrderText = $orderText;
        return $this;
    }
    /**
     * Get Order value
     * @return \StructType\Order
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\Order $order
     * @return \StructType\OrderReply
     */
    public function setOrder(\StructType\Order $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get CanPlaceOrder value
     * @return string
     */
    public function getCanPlaceOrder()
    {
        return $this->CanPlaceOrder;
    }
    /**
     * Set CanPlaceOrder value
     * @param string $canPlaceOrder
     * @return \StructType\OrderReply
     */
    public function setCanPlaceOrder($canPlaceOrder = null)
    {
        // validation for constraint: string
        if (!is_null($canPlaceOrder) && !is_string($canPlaceOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($canPlaceOrder)), __LINE__);
        }
        $this->CanPlaceOrder = $canPlaceOrder;
        return $this;
    }
    /**
     * Get StoreOrderID value
     * @return string|null
     */
    public function getStoreOrderID()
    {
        return $this->StoreOrderID;
    }
    /**
     * Set StoreOrderID value
     * @param string $storeOrderID
     * @return \StructType\OrderReply
     */
    public function setStoreOrderID($storeOrderID = null)
    {
        // validation for constraint: string
        if (!is_null($storeOrderID) && !is_string($storeOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($storeOrderID)), __LINE__);
        }
        $this->StoreOrderID = $storeOrderID;
        return $this;
    }
    /**
     * Get AdvanceOrderTime value
     * @return string|null
     */
    public function getAdvanceOrderTime()
    {
        return $this->AdvanceOrderTime;
    }
    /**
     * Set AdvanceOrderTime value
     * @param string $advanceOrderTime
     * @return \StructType\OrderReply
     */
    public function setAdvanceOrderTime($advanceOrderTime = null)
    {
        // validation for constraint: string
        if (!is_null($advanceOrderTime) && !is_string($advanceOrderTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($advanceOrderTime)), __LINE__);
        }
        $this->AdvanceOrderTime = $advanceOrderTime;
        return $this;
    }
    /**
     * Get AdvanceOrderTimeLocal value
     * @return string|null
     */
    public function getAdvanceOrderTimeLocal()
    {
        return $this->AdvanceOrderTimeLocal;
    }
    /**
     * Set AdvanceOrderTimeLocal value
     * @param string $advanceOrderTimeLocal
     * @return \StructType\OrderReply
     */
    public function setAdvanceOrderTimeLocal($advanceOrderTimeLocal = null)
    {
        // validation for constraint: string
        if (!is_null($advanceOrderTimeLocal) && !is_string($advanceOrderTimeLocal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($advanceOrderTimeLocal)), __LINE__);
        }
        $this->AdvanceOrderTimeLocal = $advanceOrderTimeLocal;
        return $this;
    }
    /**
     * Get TestOrder value
     * @return string|null
     */
    public function getTestOrder()
    {
        return $this->TestOrder;
    }
    /**
     * Set TestOrder value
     * @param string $testOrder
     * @return \StructType\OrderReply
     */
    public function setTestOrder($testOrder = null)
    {
        // validation for constraint: string
        if (!is_null($testOrder) && !is_string($testOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($testOrder)), __LINE__);
        }
        $this->TestOrder = $testOrder;
        return $this;
    }
    /**
     * Get TestDelayMS value
     * @return string|null
     */
    public function getTestDelayMS()
    {
        return $this->TestDelayMS;
    }
    /**
     * Set TestDelayMS value
     * @param string $testDelayMS
     * @return \StructType\OrderReply
     */
    public function setTestDelayMS($testDelayMS = null)
    {
        // validation for constraint: string
        if (!is_null($testDelayMS) && !is_string($testDelayMS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($testDelayMS)), __LINE__);
        }
        $this->TestDelayMS = $testDelayMS;
        return $this;
    }
    /**
     * Get PulseOrderGUID value
     * @return string|null
     */
    public function getPulseOrderGUID()
    {
        return $this->PulseOrderGUID;
    }
    /**
     * Set PulseOrderGUID value
     * @param string $pulseOrderGUID
     * @return \StructType\OrderReply
     */
    public function setPulseOrderGUID($pulseOrderGUID = null)
    {
        // validation for constraint: string
        if (!is_null($pulseOrderGUID) && !is_string($pulseOrderGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pulseOrderGUID)), __LINE__);
        }
        $this->PulseOrderGUID = $pulseOrderGUID;
        return $this;
    }
    /**
     * Get OrderProgress value
     * @return string|null
     */
    public function getOrderProgress()
    {
        return $this->OrderProgress;
    }
    /**
     * Set OrderProgress value
     * @param string $orderProgress
     * @return \StructType\OrderReply
     */
    public function setOrderProgress($orderProgress = null)
    {
        // validation for constraint: string
        if (!is_null($orderProgress) && !is_string($orderProgress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderProgress)), __LINE__);
        }
        $this->OrderProgress = $orderProgress;
        return $this;
    }
    /**
     * Get IsExpedited value
     * @return bool|null
     */
    public function getIsExpedited()
    {
        return $this->IsExpedited;
    }
    /**
     * Set IsExpedited value
     * @param bool $isExpedited
     * @return \StructType\OrderReply
     */
    public function setIsExpedited($isExpedited = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExpedited) && !is_bool($isExpedited)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isExpedited)), __LINE__);
        }
        $this->IsExpedited = $isExpedited;
        return $this;
    }
    /**
     * Get orderreplyid value
     * @return string|null
     */
    public function getOrderreplyid()
    {
        return $this->orderreplyid;
    }
    /**
     * Set orderreplyid value
     * @param string $orderreplyid
     * @return \StructType\OrderReply
     */
    public function setOrderreplyid($orderreplyid = null)
    {
        // validation for constraint: string
        if (!is_null($orderreplyid) && !is_string($orderreplyid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderreplyid)), __LINE__);
        }
        $this->orderreplyid = $orderreplyid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderReply
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
