<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItems StructType
 * @subpackage Structs
 */
class OrderItems extends AbstractStructBase
{
    /**
     * The OrderItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\OrderItem[]
     */
    public $OrderItem;
    /**
     * Constructor method for OrderItems
     * @uses OrderItems::setOrderItem()
     * @param \StructType\OrderItem[] $orderItem
     */
    public function __construct(array $orderItem = array())
    {
        $this
            ->setOrderItem($orderItem);
    }
    /**
     * Get OrderItem value
     * @return \StructType\OrderItem[]
     */
    public function getOrderItem()
    {
        return $this->OrderItem;
    }
    /**
     * Set OrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItem[] $orderItem
     * @return \StructType\OrderItems
     */
    public function setOrderItem(array $orderItem = array())
    {
        foreach ($orderItem as $orderItemsOrderItemItem) {
            // validation for constraint: itemType
            if (!$orderItemsOrderItemItem instanceof \StructType\OrderItem) {
                throw new \InvalidArgumentException(sprintf('The OrderItem property can only contain items of \StructType\OrderItem, "%s" given', is_object($orderItemsOrderItemItem) ? get_class($orderItemsOrderItemItem) : gettype($orderItemsOrderItemItem)), __LINE__);
            }
        }
        $this->OrderItem = $orderItem;
        return $this;
    }
    /**
     * Add item to OrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItem $item
     * @return \StructType\OrderItems
     */
    public function addToOrderItem(\StructType\OrderItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderItem) {
            throw new \InvalidArgumentException(sprintf('The OrderItem property can only contain items of \StructType\OrderItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrderItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
