<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItem StructType
 * @subpackage Structs
 */
class OrderItem extends AbstractStructBase
{
    /**
     * The ProductCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductCode;
    /**
     * The ProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The ItemQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemQuantity;
    /**
     * The PricedAt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PricedAt;
    /**
     * The OverrideAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OverrideAmount;
    /**
     * The OverrideType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OverrideType;
    /**
     * The OverrideCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OverrideCode;
    /**
     * The OverrideDescriptiveText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OverrideDescriptiveText;
    /**
     * The CookingInstructions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CookingInstructions;
    /**
     * The ItemModifiers
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemModifiers[]
     */
    public $ItemModifiers;
    /**
     * The LineNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LineNumber;
    /**
     * The ProductCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProductCodes[]
     */
    public $ProductCodes;
    /**
     * Constructor method for OrderItem
     * @uses OrderItem::setProductCode()
     * @uses OrderItem::setProductName()
     * @uses OrderItem::setItemQuantity()
     * @uses OrderItem::setPricedAt()
     * @uses OrderItem::setOverrideAmount()
     * @uses OrderItem::setOverrideType()
     * @uses OrderItem::setOverrideCode()
     * @uses OrderItem::setOverrideDescriptiveText()
     * @uses OrderItem::setCookingInstructions()
     * @uses OrderItem::setItemModifiers()
     * @uses OrderItem::setLineNumber()
     * @uses OrderItem::setProductCodes()
     * @param string $productCode
     * @param string $productName
     * @param string $itemQuantity
     * @param string $pricedAt
     * @param string $overrideAmount
     * @param string $overrideType
     * @param string $overrideCode
     * @param string $overrideDescriptiveText
     * @param string $cookingInstructions
     * @param \StructType\ItemModifiers[] $itemModifiers
     * @param string $lineNumber
     * @param \StructType\ProductCodes[] $productCodes
     */
    public function __construct($productCode = null, $productName = null, $itemQuantity = null, $pricedAt = null, $overrideAmount = null, $overrideType = null, $overrideCode = null, $overrideDescriptiveText = null, $cookingInstructions = null, array $itemModifiers = array(), $lineNumber = null, array $productCodes = array())
    {
        $this
            ->setProductCode($productCode)
            ->setProductName($productName)
            ->setItemQuantity($itemQuantity)
            ->setPricedAt($pricedAt)
            ->setOverrideAmount($overrideAmount)
            ->setOverrideType($overrideType)
            ->setOverrideCode($overrideCode)
            ->setOverrideDescriptiveText($overrideDescriptiveText)
            ->setCookingInstructions($cookingInstructions)
            ->setItemModifiers($itemModifiers)
            ->setLineNumber($lineNumber)
            ->setProductCodes($productCodes);
    }
    /**
     * Get ProductCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \StructType\OrderItem
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \StructType\OrderItem
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get ItemQuantity value
     * @return string|null
     */
    public function getItemQuantity()
    {
        return $this->ItemQuantity;
    }
    /**
     * Set ItemQuantity value
     * @param string $itemQuantity
     * @return \StructType\OrderItem
     */
    public function setItemQuantity($itemQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($itemQuantity) && !is_string($itemQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemQuantity)), __LINE__);
        }
        $this->ItemQuantity = $itemQuantity;
        return $this;
    }
    /**
     * Get PricedAt value
     * @return string|null
     */
    public function getPricedAt()
    {
        return $this->PricedAt;
    }
    /**
     * Set PricedAt value
     * @param string $pricedAt
     * @return \StructType\OrderItem
     */
    public function setPricedAt($pricedAt = null)
    {
        // validation for constraint: string
        if (!is_null($pricedAt) && !is_string($pricedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pricedAt)), __LINE__);
        }
        $this->PricedAt = $pricedAt;
        return $this;
    }
    /**
     * Get OverrideAmount value
     * @return string|null
     */
    public function getOverrideAmount()
    {
        return $this->OverrideAmount;
    }
    /**
     * Set OverrideAmount value
     * @param string $overrideAmount
     * @return \StructType\OrderItem
     */
    public function setOverrideAmount($overrideAmount = null)
    {
        // validation for constraint: string
        if (!is_null($overrideAmount) && !is_string($overrideAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overrideAmount)), __LINE__);
        }
        $this->OverrideAmount = $overrideAmount;
        return $this;
    }
    /**
     * Get OverrideType value
     * @return string|null
     */
    public function getOverrideType()
    {
        return $this->OverrideType;
    }
    /**
     * Set OverrideType value
     * @param string $overrideType
     * @return \StructType\OrderItem
     */
    public function setOverrideType($overrideType = null)
    {
        // validation for constraint: string
        if (!is_null($overrideType) && !is_string($overrideType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overrideType)), __LINE__);
        }
        $this->OverrideType = $overrideType;
        return $this;
    }
    /**
     * Get OverrideCode value
     * @return string|null
     */
    public function getOverrideCode()
    {
        return $this->OverrideCode;
    }
    /**
     * Set OverrideCode value
     * @param string $overrideCode
     * @return \StructType\OrderItem
     */
    public function setOverrideCode($overrideCode = null)
    {
        // validation for constraint: string
        if (!is_null($overrideCode) && !is_string($overrideCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overrideCode)), __LINE__);
        }
        $this->OverrideCode = $overrideCode;
        return $this;
    }
    /**
     * Get OverrideDescriptiveText value
     * @return string|null
     */
    public function getOverrideDescriptiveText()
    {
        return $this->OverrideDescriptiveText;
    }
    /**
     * Set OverrideDescriptiveText value
     * @param string $overrideDescriptiveText
     * @return \StructType\OrderItem
     */
    public function setOverrideDescriptiveText($overrideDescriptiveText = null)
    {
        // validation for constraint: string
        if (!is_null($overrideDescriptiveText) && !is_string($overrideDescriptiveText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overrideDescriptiveText)), __LINE__);
        }
        $this->OverrideDescriptiveText = $overrideDescriptiveText;
        return $this;
    }
    /**
     * Get CookingInstructions value
     * @return string|null
     */
    public function getCookingInstructions()
    {
        return $this->CookingInstructions;
    }
    /**
     * Set CookingInstructions value
     * @param string $cookingInstructions
     * @return \StructType\OrderItem
     */
    public function setCookingInstructions($cookingInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($cookingInstructions) && !is_string($cookingInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cookingInstructions)), __LINE__);
        }
        $this->CookingInstructions = $cookingInstructions;
        return $this;
    }
    /**
     * Get ItemModifiers value
     * @return \StructType\ItemModifiers[]|null
     */
    public function getItemModifiers()
    {
        return $this->ItemModifiers;
    }
    /**
     * Set ItemModifiers value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemModifiers[] $itemModifiers
     * @return \StructType\OrderItem
     */
    public function setItemModifiers(array $itemModifiers = array())
    {
        foreach ($itemModifiers as $orderItemItemModifiersItem) {
            // validation for constraint: itemType
            if (!$orderItemItemModifiersItem instanceof \StructType\ItemModifiers) {
                throw new \InvalidArgumentException(sprintf('The ItemModifiers property can only contain items of \StructType\ItemModifiers, "%s" given', is_object($orderItemItemModifiersItem) ? get_class($orderItemItemModifiersItem) : gettype($orderItemItemModifiersItem)), __LINE__);
            }
        }
        $this->ItemModifiers = $itemModifiers;
        return $this;
    }
    /**
     * Add item to ItemModifiers value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemModifiers $item
     * @return \StructType\OrderItem
     */
    public function addToItemModifiers(\StructType\ItemModifiers $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemModifiers) {
            throw new \InvalidArgumentException(sprintf('The ItemModifiers property can only contain items of \StructType\ItemModifiers, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemModifiers[] = $item;
        return $this;
    }
    /**
     * Get LineNumber value
     * @return string|null
     */
    public function getLineNumber()
    {
        return $this->LineNumber;
    }
    /**
     * Set LineNumber value
     * @param string $lineNumber
     * @return \StructType\OrderItem
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: string
        if (!is_null($lineNumber) && !is_string($lineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineNumber)), __LINE__);
        }
        $this->LineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get ProductCodes value
     * @return \StructType\ProductCodes[]|null
     */
    public function getProductCodes()
    {
        return $this->ProductCodes;
    }
    /**
     * Set ProductCodes value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductCodes[] $productCodes
     * @return \StructType\OrderItem
     */
    public function setProductCodes(array $productCodes = array())
    {
        foreach ($productCodes as $orderItemProductCodesItem) {
            // validation for constraint: itemType
            if (!$orderItemProductCodesItem instanceof \StructType\ProductCodes) {
                throw new \InvalidArgumentException(sprintf('The ProductCodes property can only contain items of \StructType\ProductCodes, "%s" given', is_object($orderItemProductCodesItem) ? get_class($orderItemProductCodesItem) : gettype($orderItemProductCodesItem)), __LINE__);
            }
        }
        $this->ProductCodes = $productCodes;
        return $this;
    }
    /**
     * Add item to ProductCodes value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductCodes $item
     * @return \StructType\OrderItem
     */
    public function addToProductCodes(\StructType\ProductCodes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductCodes) {
            throw new \InvalidArgumentException(sprintf('The ProductCodes property can only contain items of \StructType\ProductCodes, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductCodes[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
