<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderInfo StructType
 * @subpackage Structs
 */
class OrderInfo extends AbstractStructBase
{
    /**
     * The KeyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $KeyCode;
    /**
     * The Response
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Response;
    /**
     * Constructor method for OrderInfo
     * @uses OrderInfo::setKeyCode()
     * @uses OrderInfo::setResponse()
     * @param string $keyCode
     * @param string $response
     */
    public function __construct($keyCode = null, $response = null)
    {
        $this
            ->setKeyCode($keyCode)
            ->setResponse($response);
    }
    /**
     * Get KeyCode value
     * @return string
     */
    public function getKeyCode()
    {
        return $this->KeyCode;
    }
    /**
     * Set KeyCode value
     * @param string $keyCode
     * @return \StructType\OrderInfo
     */
    public function setKeyCode($keyCode = null)
    {
        // validation for constraint: string
        if (!is_null($keyCode) && !is_string($keyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyCode)), __LINE__);
        }
        $this->KeyCode = $keyCode;
        return $this;
    }
    /**
     * Get Response value
     * @return string
     */
    public function getResponse()
    {
        return $this->Response;
    }
    /**
     * Set Response value
     * @param string $response
     * @return \StructType\OrderInfo
     */
    public function setResponse($response = null)
    {
        // validation for constraint: string
        if (!is_null($response) && !is_string($response)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($response)), __LINE__);
        }
        $this->Response = $response;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
