<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Notification StructType
 * @subpackage Structs
 */
class Notification extends AbstractStructBase
{
    /**
     * The NotificationURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotificationURL;
    /**
     * The NotificationExpiration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotificationExpiration;
    /**
     * The NotificationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotificationID;
    /**
     * The MustNotify
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MustNotify;
    /**
     * Constructor method for Notification
     * @uses Notification::setNotificationURL()
     * @uses Notification::setNotificationExpiration()
     * @uses Notification::setNotificationID()
     * @uses Notification::setMustNotify()
     * @param string $notificationURL
     * @param string $notificationExpiration
     * @param string $notificationID
     * @param string $mustNotify
     */
    public function __construct($notificationURL = null, $notificationExpiration = null, $notificationID = null, $mustNotify = null)
    {
        $this
            ->setNotificationURL($notificationURL)
            ->setNotificationExpiration($notificationExpiration)
            ->setNotificationID($notificationID)
            ->setMustNotify($mustNotify);
    }
    /**
     * Get NotificationURL value
     * @return string|null
     */
    public function getNotificationURL()
    {
        return $this->NotificationURL;
    }
    /**
     * Set NotificationURL value
     * @param string $notificationURL
     * @return \StructType\Notification
     */
    public function setNotificationURL($notificationURL = null)
    {
        // validation for constraint: string
        if (!is_null($notificationURL) && !is_string($notificationURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationURL)), __LINE__);
        }
        $this->NotificationURL = $notificationURL;
        return $this;
    }
    /**
     * Get NotificationExpiration value
     * @return string|null
     */
    public function getNotificationExpiration()
    {
        return $this->NotificationExpiration;
    }
    /**
     * Set NotificationExpiration value
     * @param string $notificationExpiration
     * @return \StructType\Notification
     */
    public function setNotificationExpiration($notificationExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($notificationExpiration) && !is_string($notificationExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationExpiration)), __LINE__);
        }
        $this->NotificationExpiration = $notificationExpiration;
        return $this;
    }
    /**
     * Get NotificationID value
     * @return string|null
     */
    public function getNotificationID()
    {
        return $this->NotificationID;
    }
    /**
     * Set NotificationID value
     * @param string $notificationID
     * @return \StructType\Notification
     */
    public function setNotificationID($notificationID = null)
    {
        // validation for constraint: string
        if (!is_null($notificationID) && !is_string($notificationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationID)), __LINE__);
        }
        $this->NotificationID = $notificationID;
        return $this;
    }
    /**
     * Get MustNotify value
     * @return string|null
     */
    public function getMustNotify()
    {
        return $this->MustNotify;
    }
    /**
     * Set MustNotify value
     * @param string $mustNotify
     * @return \StructType\Notification
     */
    public function setMustNotify($mustNotify = null)
    {
        // validation for constraint: string
        if (!is_null($mustNotify) && !is_string($mustNotify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mustNotify)), __LINE__);
        }
        $this->MustNotify = $mustNotify;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Notification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
