<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemModifiers StructType
 * @subpackage Structs
 */
class ItemModifiers extends AbstractStructBase
{
    /**
     * The ItemModifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ItemModifier[]
     */
    public $ItemModifier;
    /**
     * Constructor method for ItemModifiers
     * @uses ItemModifiers::setItemModifier()
     * @param \StructType\ItemModifier[] $itemModifier
     */
    public function __construct(array $itemModifier = array())
    {
        $this
            ->setItemModifier($itemModifier);
    }
    /**
     * Get ItemModifier value
     * @return \StructType\ItemModifier[]
     */
    public function getItemModifier()
    {
        return $this->ItemModifier;
    }
    /**
     * Set ItemModifier value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemModifier[] $itemModifier
     * @return \StructType\ItemModifiers
     */
    public function setItemModifier(array $itemModifier = array())
    {
        foreach ($itemModifier as $itemModifiersItemModifierItem) {
            // validation for constraint: itemType
            if (!$itemModifiersItemModifierItem instanceof \StructType\ItemModifier) {
                throw new \InvalidArgumentException(sprintf('The ItemModifier property can only contain items of \StructType\ItemModifier, "%s" given', is_object($itemModifiersItemModifierItem) ? get_class($itemModifiersItemModifierItem) : gettype($itemModifiersItemModifierItem)), __LINE__);
            }
        }
        $this->ItemModifier = $itemModifier;
        return $this;
    }
    /**
     * Add item to ItemModifier value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemModifier $item
     * @return \StructType\ItemModifiers
     */
    public function addToItemModifier(\StructType\ItemModifier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemModifier) {
            throw new \InvalidArgumentException(sprintf('The ItemModifier property can only contain items of \StructType\ItemModifier, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemModifier[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemModifiers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
